/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.Map;
import org.babyfish.jimmer.sql.ast.mutation.AbstractMutationResult;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;

public class SimpleSaveResult<E>
extends AbstractMutationResult {
    private E originalEntity;
    private E modifiedEntity;

    public SimpleSaveResult(Map<AffectedTable, Integer> affectedRowCountMap, E originalEntity, E modifiedEntity) {
        super(affectedRowCountMap);
        this.originalEntity = originalEntity;
        this.modifiedEntity = modifiedEntity;
    }

    public SimpleSaveResult<E> copy(E modifiedEntity) {
        if (this.modifiedEntity == modifiedEntity) {
            return this;
        }
        return new SimpleSaveResult<E>(this.affectedRowCountMap, this.originalEntity, modifiedEntity);
    }

    public E getOriginalEntity() {
        return this.originalEntity;
    }

    public E getModifiedEntity() {
        return this.modifiedEntity;
    }

    public boolean isModified() {
        return this.originalEntity != this.modifiedEntity;
    }

    public int hashCode() {
        int hash = this.affectedRowCountMap.hashCode();
        hash = hash * 31 + System.identityHashCode(this.originalEntity);
        hash = hash * 31 + System.identityHashCode(this.modifiedEntity);
        return hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleSaveResult that = (SimpleSaveResult)o;
        return this.affectedRowCountMap.equals(that.affectedRowCountMap) && this.originalEntity == that.originalEntity && this.modifiedEntity == that.modifiedEntity;
    }

    public String toString() {
        return "SimpleSaveResult{totalAffectedRowCount=" + this.totalAffectedRowCount + ", affectedRowCountMap=" + this.affectedRowCountMap + ", originalEntity=" + this.originalEntity + ", modifiedEntity=" + this.modifiedEntity + '}';
    }
}

