/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.mutation.MiddleTableOperator;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.meta.MiddleTable;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

class AssociationExecutable
implements Executable<Integer> {
    final JSqlClient sqlClient;
    final Connection con;
    private final AssociationType associationType;
    private final boolean reversed;
    private final Mode mode;
    private final Set<Tuple2<Object, Object>> idTuples;

    public AssociationExecutable(JSqlClient sqlClient, Connection con, AssociationType associationType, boolean reversed, Mode mode, Collection<Tuple2<Object, Object>> idTuples) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.associationType = associationType;
        this.reversed = reversed;
        this.mode = mode;
        this.idTuples = idTuples instanceof Set ? (Set<Object>)idTuples : new LinkedHashSet<Tuple2<Object, Object>>(idTuples);
    }

    public AssociationExecutable setMode(Mode mode) {
        if (this.mode == mode) {
            return this;
        }
        return new AssociationExecutable(this.sqlClient, this.con, this.associationType, this.reversed, mode, this.idTuples);
    }

    @Override
    public Integer execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Integer execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private Integer executeImpl(Connection con) {
        if (this.idTuples.isEmpty()) {
            return 0;
        }
        if (this.mode == Mode.DELETE) {
            return this.getMiddleTypeOperator(con).remove(new TupleReader(this.idTuples));
        }
        Set<Tuple2<Object, Object>> addingPairs = this.idTuples;
        if (this.mode == Mode.CHECK_AND_INSERT) {
            addingPairs = new LinkedHashSet<Tuple2<Object, Object>>(addingPairs);
            HashSet<Tuple2<Object, Object>> existingPairs = new HashSet<Tuple2<Object, Object>>(this.find(con));
            addingPairs.removeAll(existingPairs);
            if (addingPairs.isEmpty()) {
                return 0;
            }
        }
        return this.getMiddleTypeOperator(con).add(new TupleReader(addingPairs));
    }

    private List<Tuple2<Object, Object>> find(Connection con) {
        MiddleTable middleTable = this.reversed ? this.associationType.getMiddleTable().getInverse() : this.associationType.getMiddleTable();
        Tuple2<Expression<?>, Expression<?>> expressionPair = this.getExpressionPair();
        SqlBuilder builder = new SqlBuilder(new AstContext(this.sqlClient));
        builder.sql("select ").sql(middleTable.getJoinColumnName()).sql(", ").sql(middleTable.getTargetJoinColumnName()).sql(" from ").sql(this.associationType.getTableName()).sql(" where (").sql(middleTable.getJoinColumnName()).sql(", ").sql(middleTable.getTargetJoinColumnName()).sql(") in(");
        String separator = "";
        for (Tuple2<Object, Object> idTuple : this.idTuples) {
            builder.sql(separator).sql("(").variable(idTuple.get_1()).sql(", ").variable(idTuple.get_2()).sql(")");
            separator = ", ";
        }
        builder.sql(")");
        Tuple2<String, List<Object>> sqlResult = builder.build();
        return Selectors.select(this.sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), Arrays.asList(expressionPair.get_1(), expressionPair.get_2()), ExecutionPurpose.QUERY);
    }

    private Tuple2<Expression<?>, Expression<?>> getExpressionPair() {
        Class srcType = this.associationType.getSourceType().getIdProp().getElementClass();
        Class tgtType = this.associationType.getTargetType().getIdProp().getElementClass();
        if (this.reversed) {
            return new Tuple2(Expression.any().nullValue(tgtType), Expression.any().nullValue(srcType));
        }
        return new Tuple2(Expression.any().nullValue(srcType), Expression.any().nullValue(tgtType));
    }

    private MiddleTableOperator getMiddleTypeOperator(Connection con) {
        return new MiddleTableOperator(this.sqlClient, con, this.reversed ? this.associationType.getMiddleTable().getInverse() : this.associationType.getMiddleTable(), (this.reversed ? this.associationType.getSourceType() : this.associationType.getTargetType()).getIdProp().getElementClass());
    }

    public static enum Mode {
        CHECK_AND_INSERT,
        INSERT,
        DELETE;

    }

    private static class TupleReader
    implements MiddleTableOperator.IdPairReader {
        private Iterator<Tuple2<Object, Object>> idTupleItr;
        private Tuple2<Object, Object> currentIdPair;

        TupleReader(Collection<Tuple2<Object, Object>> idTuples) {
            this.idTupleItr = idTuples.iterator();
        }

        @Override
        public boolean read() {
            if (this.idTupleItr.hasNext()) {
                this.currentIdPair = this.idTupleItr.next();
                return true;
            }
            return false;
        }

        @Override
        public Object sourceId() {
            return this.currentIdPair.get_1();
        }

        @Override
        public Object targetId() {
            return this.currentIdPair.get_2();
        }
    }
}

