/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.Column;

abstract class AbstractEntitySaveCommandImpl
implements AbstractEntitySaveCommand {
    final JSqlClient sqlClient;
    final Connection con;
    final Data data;

    AbstractEntitySaveCommandImpl(JSqlClient sqlClient, Connection con, Data data) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.data = data != null ? data.freeze() : new Data(sqlClient).freeze();
    }

    @Override
    public AbstractEntitySaveCommand configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (newData.mode == SaveMode.UPSERT && newData.keyPropMultiMap.isEmpty() && !newData.autoAttachingAll && newData.dissociateActionMap.isEmpty() && newData.autoAttachingSet.isEmpty()) {
            return this;
        }
        return this.create(newData);
    }

    abstract AbstractEntitySaveCommand create(Data var1);

    static class Data
    implements AbstractEntitySaveCommand.Cfg {
        private JSqlClient sqlClient;
        private boolean frozen;
        private SaveMode mode;
        private Map<ImmutableType, Set<ImmutableProp>> keyPropMultiMap;
        private boolean autoAttachingAll;
        private Set<ImmutableProp> autoAttachingSet;
        private Map<ImmutableProp, DissociateAction> dissociateActionMap;

        Data(JSqlClient sqlClient) {
            this.sqlClient = sqlClient;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>();
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>();
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>(base.keyPropMultiMap);
            this.autoAttachingAll = base.autoAttachingAll;
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>(base.autoAttachingSet);
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>(base.dissociateActionMap);
        }

        public JSqlClient getSqlClient() {
            return this.sqlClient;
        }

        public SaveMode getMode() {
            return this.mode;
        }

        public Set<ImmutableProp> getKeyProps(ImmutableType type) {
            Set<ImmutableProp> keyProps = this.keyPropMultiMap.get(type);
            if (keyProps != null) {
                return keyProps;
            }
            return type.getKeyProps();
        }

        public boolean isAutoAttachingProp(ImmutableProp prop) {
            return this.autoAttachingAll || this.autoAttachingSet.contains(prop);
        }

        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        Map<ImmutableProp, DissociateAction> dissociateActionMap() {
            return this.dissociateActionMap;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setMode(SaveMode mode) {
            this.validate();
            this.mode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setKeyProps(ImmutableProp ... props) {
            this.validate();
            ImmutableType type = null;
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : props) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is version property");
                }
                if (prop.isAssociation(TargetLevel.ENTITY) || !(prop.getStorage() instanceof Column)) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is not a scalar property with storage");
                }
                if (prop.isNullable()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is nullable");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties must belong to one type");
                }
                set.add(prop);
            }
            if (type != null) {
                this.keyPropMultiMap.put(type, set);
            }
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttachingAll() {
            this.autoAttachingAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttaching(ImmutableProp prop) {
            this.validate();
            this.autoAttachingSet.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
            this.validate();
            if (!prop.isReference(TargetLevel.ENTITY) || !(prop.getStorage() instanceof Column)) {
                throw new IllegalArgumentException("'" + prop + "' must be an reference property bases on foreign key");
            }
            if (dissociateAction == DissociateAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            this.dissociateActionMap.put(prop, dissociateAction);
            return this;
        }

        public Data freeze() {
            if (!this.frozen) {
                this.keyPropMultiMap = Collections.unmodifiableMap(this.keyPropMultiMap);
                this.autoAttachingSet = Collections.unmodifiableSet(this.autoAttachingSet);
                this.dissociateActionMap = Collections.unmodifiableMap(this.dissociateActionMap);
                this.frozen = true;
            }
            return this;
        }

        private void validate() {
            if (this.frozen) {
                throw new IllegalStateException("The current configuration is frozen");
            }
        }
    }

    private static class KeyPropCfgImpl<T extends Table<?>>
    implements AbstractEntitySaveCommand.KeyPropCfg<T> {
        private Class<T> tableType;
        private List<ImmutableProp> props = new ArrayList<ImmutableProp>();

        KeyPropCfgImpl(Class<T> tableType) {
            this.tableType = tableType;
        }

        public List<ImmutableProp> getProps() {
            return this.props;
        }

        @Override
        public AbstractEntitySaveCommand.KeyPropCfg<T> add(ImmutableProp prop) {
            this.props.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.KeyPropCfg<T> add(TypedProp<?, ?> prop) {
            return this.add(prop.unwrap());
        }
    }
}

