/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.meta.impl.RedirectedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DefaultScalarProviders;
import org.babyfish.jimmer.sql.DraftInterceptor;
import org.babyfish.jimmer.sql.DraftInterceptorManager;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.TransientResolverManager;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AssociationsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableDeleteImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggersImpl;
import org.babyfish.jimmer.sql.filter.Filter;
import org.babyfish.jimmer.sql.filter.FilterConfig;
import org.babyfish.jimmer.sql.filter.Filters;
import org.babyfish.jimmer.sql.filter.impl.FilterManager;
import org.babyfish.jimmer.sql.loader.Loaders;
import org.babyfish.jimmer.sql.loader.impl.LoadersImpl;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.EntityManager;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

class JSqlClientImpl
implements JSqlClient {
    private final ConnectionManager connectionManager;
    private final ConnectionManager slaveConnectionManager;
    private final Dialect dialect;
    private final Executor executor;
    private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap;
    private final Map<Class<?>, IdGenerator> idGeneratorMap;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final EntitiesImpl entities;
    private final EntityManager entityManager;
    private final Caches caches;
    private final Triggers triggers;
    private final TransientResolverManager transientResolverManager;
    private final FilterManager filterManager;
    private final DraftInterceptorManager draftInterceptorManager;
    private final Loaders loaders = new LoadersImpl(this);

    private JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, Map<Class<?>, IdGenerator> idGeneratorMap, int defaultBatchSize, int defaultListBatchSize, EntitiesImpl entities, EntityManager entityManager, Caches caches, Triggers triggers, FilterManager filterManager, TransientResolverManager transientResolverManager, DraftInterceptorManager draftInterceptorManager) {
        this.connectionManager = connectionManager != null ? connectionManager : ConnectionManager.ILLEGAL;
        this.slaveConnectionManager = slaveConnectionManager;
        this.dialect = dialect != null ? dialect : new DefaultDialect();
        this.executor = executor != null ? executor : DefaultExecutor.INSTANCE;
        this.scalarProviderMap = scalarProviderMap;
        this.idGeneratorMap = idGeneratorMap;
        this.defaultBatchSize = defaultBatchSize;
        this.defaultListBatchSize = defaultListBatchSize;
        this.entities = entities != null ? entities.forSqlClient(this) : new EntitiesImpl(this);
        this.entityManager = entityManager;
        this.caches = caches != null ? caches : CachesImpl.of(triggers, scalarProviderMap, entityManager, null);
        this.triggers = triggers;
        this.filterManager = filterManager;
        this.transientResolverManager = transientResolverManager != null ? transientResolverManager : this.createTransientResolverManager();
        this.draftInterceptorManager = draftInterceptorManager;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionManager getSlaveConnectionManager(boolean forUpdate) {
        ConnectionManager slave = this.slaveConnectionManager;
        if (slave != null && !forUpdate) {
            return slave;
        }
        return this.connectionManager;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> scalarType) {
        ScalarProvider<?, ?> provider = this.scalarProviderMap.get(scalarType);
        return provider != null ? provider : DefaultScalarProviders.getProvider(scalarType);
    }

    @Override
    public IdGenerator getIdGenerator(Class<?> entityType) {
        IdGenerator userIdGenerator = this.idGeneratorMap.get(entityType);
        if (userIdGenerator == null && (userIdGenerator = this.idGeneratorMap.get(null)) == null) {
            userIdGenerator = ImmutableType.get(entityType).getIdGenerator();
        }
        return userIdGenerator;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @Override
    public <T extends TableProxy<?>> MutableRootQuery<T> createQuery(T table) {
        if (table instanceof TableEx) {
            throw new IllegalArgumentException("Top-level query does not support TableEx");
        }
        return new MutableRootQueryImpl((JSqlClient)this, table, ExecutionPurpose.QUERY, false);
    }

    @Override
    public MutableUpdate createUpdate(TableProxy<?> table) {
        return new MutableUpdateImpl((JSqlClient)this, table);
    }

    @Override
    public MutableDelete createDelete(TableProxy<?> table) {
        return new MutableDeleteImpl((JSqlClient)this, table);
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> MutableRootQuery<AssociationTable<SE, ST, TE, TT>> createAssociationQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableRootQueryImpl<AssociationTable<SE, ST, TE, TT>>((JSqlClient)this, (TableProxy)((Object)table), ExecutionPurpose.QUERY, false);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return new MutableSubQueryImpl((JSqlClient)this, table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        if (!(table instanceof TableProxy)) {
            throw new IllegalArgumentException("The argument \"table\" must be proxy");
        }
        return new MutableSubQueryImpl((JSqlClient)this, (TableProxy)((Object)table));
    }

    @Override
    public Entities getEntities() {
        return this.entities;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    @Override
    public Associations getAssociations(TypedProp.Association<?, ?> prop) {
        return this.getAssociations(prop.unwrap());
    }

    @Override
    public Associations getAssociations(ImmutableProp immutableProp) {
        return this.getAssociations(AssociationType.of(immutableProp));
    }

    @Override
    public Associations getAssociations(AssociationType associationType) {
        return new AssociationsImpl(this, null, associationType);
    }

    @Override
    public Loaders getLoaders() {
        return this.loaders;
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Caches getCaches() {
        return this.caches;
    }

    @Override
    public JSqlClient caches(Consumer<CacheDisableConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        CacheDisableConfig cfg = new CacheDisableConfig();
        block.accept(cfg);
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.entityManager, new CachesImpl((CachesImpl)this.caches, cfg), this.triggers, this.filterManager, this.transientResolverManager, this.draftInterceptorManager);
    }

    @Override
    public JSqlClient filters(Consumer<FilterConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        FilterConfig cfg = new FilterConfig(this.filterManager);
        block.accept(cfg);
        if (cfg.getFilterManager() == this.filterManager) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.entityManager, this.caches, this.triggers, cfg.getFilterManager(), this.transientResolverManager, this.draftInterceptorManager);
    }

    @Override
    public JSqlClient disableSlaveConnectionManager() {
        if (this.slaveConnectionManager == null) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, null, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.entityManager, this.caches, this.triggers, this.filterManager, this.transientResolverManager, this.draftInterceptorManager);
    }

    @Override
    public TransientResolver<?, ?> getResolver(ImmutableProp prop) {
        return this.transientResolverManager.get(prop);
    }

    @Override
    public Filters getFilters() {
        return this.filterManager;
    }

    @Override
    public DraftInterceptor<?> getDraftInterceptor(ImmutableType type) {
        return this.draftInterceptorManager.get(type);
    }

    private TransientResolverManager createTransientResolverManager() {
        TransientResolverManager manager = new TransientResolverManager(this);
        if (this.caches != null) {
            for (ImmutableType type : ((CachesImpl)this.caches).getObjectCacheMap().keySet()) {
                for (ImmutableProp prop : type.getProps().values()) {
                    if (!prop.hasTransientResolver()) continue;
                    manager.get(RedirectedProp.source((ImmutableProp)prop, (ImmutableType)type));
                }
            }
            for (ImmutableProp prop : ((CachesImpl)this.caches).getPropCacheMap().keySet()) {
                if (!prop.hasTransientResolver()) continue;
                manager.get(prop);
            }
        }
        return manager;
    }

    public static class BuilderImpl
    implements JSqlClient.Builder {
        private ConnectionManager connectionManager;
        private ConnectionManager slaveConnectionManager;
        private Dialect dialect;
        private Executor executor;
        private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap = new HashMap();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private EntityManager entityManager;
        private Caches caches;
        private final Triggers triggers = new TriggersImpl();
        private final List<Filter<?>> filters = new ArrayList();
        private final Set<Filter<?>> disabledFilters = new HashSet();
        private final List<DraftInterceptor<?>> interceptors = new ArrayList();

        @Override
        public JSqlClient.Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setSlaveConnectionManager(ConnectionManager connectionManager) {
            this.slaveConnectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        @Override
        public JSqlClient.Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            if (this.scalarProviderMap.containsKey(scalarProvider.getScalarType())) {
                throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarProvider.getScalarType() + "\" twice");
            }
            this.scalarProviderMap.put(scalarProvider.getScalarType(), scalarProvider);
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setEntityManager(EntityManager scanner) {
            if (this.entityManager != null) {
                throw new IllegalStateException("The EntityManager of SqlBuilder.Builder can only be set once");
            }
            this.entityManager = scanner;
            return this;
        }

        @Override
        public JSqlClient.Builder setCaches(Consumer<CacheConfig> block) {
            this.caches = CachesImpl.of(this.triggers, this.scalarProviderMap, this.entityManager, block);
            return this;
        }

        @Override
        public JSqlClient.Builder addFilters(Filter<?> ... filters) {
            return this.addFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addFilters(Collection<Filter<?>> filters) {
            this.filters.addAll(filters);
            this.disabledFilters.removeAll(filters);
            return this;
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Filter<?> ... filters) {
            return this.addDisabledFilters(Arrays.asList(filters));
        }

        @Override
        public JSqlClient.Builder addDisabledFilters(Collection<Filter<?>> filters) {
            this.filters.addAll(filters);
            this.disabledFilters.addAll(filters);
            return this;
        }

        @Override
        public JSqlClient.Builder addDraftInterceptor(DraftInterceptor<?> interceptor) {
            return this.addDraftInterceptors(Collections.singletonList(interceptor));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(DraftInterceptor<?> ... interceptors) {
            return this.addDraftInterceptors(Arrays.asList(interceptors));
        }

        @Override
        public JSqlClient.Builder addDraftInterceptors(Collection<DraftInterceptor<?>> interceptors) {
            this.interceptors.addAll(interceptors);
            return this;
        }

        @Override
        public JSqlClient build() {
            FilterManager filterManager = new FilterManager(this.filters, this.disabledFilters);
            JSqlClientImpl sqlClient = new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, null, this.entityManager, this.caches, this.triggers, filterManager, null, new DraftInterceptorManager(this.interceptors));
            filterManager.initialize(sqlClient);
            return sqlClient;
        }
    }
}

