/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.filter.impl;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Props;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.filter.FilterArgs;
import org.jetbrains.annotations.NotNull;

public class FilterArgsImpl<P extends Props>
implements FilterArgs<P> {
    private static final String JOIN_DISABLED_REASON = "The table for cacheable filter is not allow to join with other tables";
    private static final String SUB_QUERY_DISABLED_MESSAGE = "The cacheable filter cannot be used to create sub query";
    private final Sortable sortable;
    private final P props;
    private boolean forCache;

    public FilterArgsImpl(Sortable sortable, Props props, boolean forCache) {
        this.sortable = sortable;
        if (forCache) {
            props = props instanceof TableImplementor ? new UntypedTableProxy((TableImplementor)((Object)props)) : ((TableProxy)props).__disableJoin(JOIN_DISABLED_REASON);
        }
        this.props = props;
        this.forCache = forCache;
    }

    @Override
    @NotNull
    public P getTable() {
        return this.props;
    }

    @Override
    public Sortable where(Predicate ... predicates) {
        return this.sortable.where(predicates);
    }

    @Override
    public Sortable orderBy(Expression<?> ... expressions) {
        return this.sortable.orderBy(expressions);
    }

    @Override
    public Sortable orderBy(Order ... orders) {
        return this.sortable.orderBy(orders);
    }

    @Override
    public MutableSubQuery createSubQuery(TableProxy<?> table) {
        return this.sortable.createSubQuery(table);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>> MutableSubQuery createAssociationSubQuery(AssociationTable<SE, ST, TE, TT> table) {
        return this.sortable.createAssociationSubQuery(table);
    }

    public AbstractMutableQueryImpl unwrap() {
        return (AbstractMutableQueryImpl)this.sortable;
    }

    private static class UntypedTableProxy<E>
    implements TableProxy<E> {
        private final TableImplementor<E> table;
        private final String joinDisabledReason;

        UntypedTableProxy(TableImplementor<E> table) {
            this(table, FilterArgsImpl.JOIN_DISABLED_REASON);
        }

        UntypedTableProxy(TableImplementor<E> table, String joinDisabledReason) {
            this.table = table;
            this.joinDisabledReason = joinDisabledReason;
        }

        @Override
        public ImmutableType getImmutableType() {
            return this.table.getImmutableType();
        }

        @Override
        public <XE extends Expression<?>> XE get(String prop) {
            return this.table.get(prop);
        }

        @Override
        public <XT extends Table<?>> XT join(String prop) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
            throw new IllegalStateException(this.joinDisabledReason);
        }

        @Override
        public Predicate eq(Table<E> other) {
            return this.table.eq(other);
        }

        @Override
        public Predicate isNull() {
            return this.table.isNull();
        }

        @Override
        public Predicate isNotNull() {
            return this.table.isNotNull();
        }

        @Override
        public NumericExpression<Long> count() {
            return this.table.count();
        }

        @Override
        public NumericExpression<Long> count(boolean distinct) {
            return this.table.count(distinct);
        }

        @Override
        public Selection<E> fetch(Fetcher<E> fetcher) {
            return this.table.fetch(fetcher);
        }

        @Override
        public TableEx<E> asTableEx() {
            return this.table.asTableEx();
        }

        @Override
        public Table<?> __parent() {
            return this.table.getParent();
        }

        @Override
        public ImmutableProp __prop() {
            return this.table.getJoinProp();
        }

        @Override
        public TableImplementor<E> __unwrap() {
            return this.table;
        }

        @Override
        public TableImplementor<E> __resolve(RootTableResolver resolver) {
            return null;
        }

        @Override
        public <P extends TableProxy<E>> P __disableJoin(String reason) {
            return (P)new UntypedTableProxy<E>(this.table, reason);
        }
    }
}

