/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.util.Classes;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AssociationEvent {
    private final ImmutableProp prop;
    private final Object sourceId;
    private final Object detachedTargetId;
    private final Object attachedTargetId;
    private final Object reason;

    public AssociationEvent(ImmutableProp prop, Object sourceId, Object reason) {
        this.validateConstructorArgs(prop, sourceId);
        this.prop = prop;
        this.sourceId = sourceId;
        this.detachedTargetId = null;
        this.attachedTargetId = null;
        this.reason = reason;
    }

    public AssociationEvent(ImmutableProp prop, Object sourceId, Object detachedTargetId, Object attachedTargetId, Object reason) {
        this.validateConstructorArgs(prop, sourceId);
        if (detachedTargetId == null && attachedTargetId == null) {
            throw new IllegalArgumentException("Both `detachedTargetId` and `attachedTargetId` is null, this is not allowed");
        }
        Class expectedTargetIdClass = prop.getTargetType().getIdProp().getElementClass();
        if (detachedTargetId != null && !Classes.matches((Class)expectedTargetIdClass, detachedTargetId.getClass())) {
            throw new IllegalArgumentException("The type of detachedTargetId \"" + sourceId + "\" does not match \"" + prop.getTargetType().getIdProp() + "\"");
        }
        if (attachedTargetId != null && !Classes.matches((Class)expectedTargetIdClass, attachedTargetId.getClass())) {
            throw new IllegalArgumentException("The type of attachedTargetId \"" + sourceId + "\" does not match \"" + prop.getTargetType().getIdProp() + "\"");
        }
        this.prop = prop;
        this.sourceId = sourceId;
        this.detachedTargetId = detachedTargetId;
        this.attachedTargetId = attachedTargetId;
        this.reason = reason;
    }

    private void validateConstructorArgs(ImmutableProp prop, Object sourceId) {
        if (prop == null) {
            throw new IllegalArgumentException("prop cannot be null");
        }
        if (!prop.isAssociation(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("prop must be association");
        }
        if (sourceId == null || !Classes.matches((Class)prop.getDeclaringType().getIdProp().getElementClass(), sourceId.getClass())) {
            throw new IllegalArgumentException("The type of sourceId \"" + sourceId + "\" does not match \"" + prop.getDeclaringType().getIdProp() + "\"");
        }
    }

    @NotNull
    public ImmutableProp getImmutableProp() {
        return this.prop;
    }

    @NotNull
    public Object getSourceId() {
        return this.sourceId;
    }

    @Nullable
    public Object getDetachedTargetId() {
        this.validateTarget();
        return this.detachedTargetId;
    }

    @Nullable
    public Object getAttachedTargetId() {
        this.validateTarget();
        return this.attachedTargetId;
    }

    @Nullable
    public Object getReason() {
        return this.reason;
    }

    @NotNull
    public Type getType() {
        if (this.detachedTargetId == null && this.attachedTargetId == null) {
            return Type.EVICT;
        }
        if (this.detachedTargetId == null) {
            return Type.ATTACH;
        }
        if (this.attachedTargetId == null) {
            return Type.DETACH;
        }
        return Type.REPLACE;
    }

    private void validateTarget() {
        if (this.detachedTargetId == null && this.attachedTargetId == null) {
            throw new IllegalStateException("Cannot get target id because the event type is `EVICT`");
        }
    }

    public int hashCode() {
        return Objects.hash(this.prop, this.sourceId, this.detachedTargetId, this.attachedTargetId, this.reason);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationEvent that = (AssociationEvent)o;
        return this.prop.equals((Object)that.prop) && this.sourceId.equals(that.sourceId) && Objects.equals(this.detachedTargetId, that.detachedTargetId) && Objects.equals(this.attachedTargetId, that.attachedTargetId) && Objects.equals(this.reason, that.reason);
    }

    public String toString() {
        return "AssociationEvent{prop=" + this.prop + ", sourceId=" + this.sourceId + ", detachedTargetId=" + this.detachedTargetId + ", attachedTargetId=" + this.attachedTargetId + ", reason=" + this.reason + '}';
    }

    public static enum Type {
        DETACH,
        ATTACH,
        REPLACE,
        EVICT;

    }
}

