/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.table.spi;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.meta.impl.RedirectedProp;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.PropExpressionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.FetcherSelectionImpl;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.fetcher.Fetcher;

public abstract class AbstractTypedTable<E>
implements TableProxy<E> {
    private final ImmutableType immutableType;
    protected final TableImplementor<E> raw;
    private final DelayedOperation<E> delayedOperation;
    private final String joinDisabledReason;

    protected AbstractTypedTable(ImmutableType type) {
        this.immutableType = type;
        this.raw = null;
        this.delayedOperation = null;
        this.joinDisabledReason = null;
    }

    protected AbstractTypedTable(Class<E> entityType) {
        this.immutableType = ImmutableType.get(entityType);
        this.raw = null;
        this.delayedOperation = null;
        this.joinDisabledReason = null;
    }

    protected AbstractTypedTable(Class<E> entityType, DelayedOperation<E> delayedOperation) {
        this.immutableType = ImmutableType.get(entityType);
        this.raw = null;
        this.delayedOperation = delayedOperation;
        this.joinDisabledReason = null;
    }

    protected AbstractTypedTable(TableImplementor<E> raw) {
        this.immutableType = raw.getImmutableType();
        this.raw = raw;
        this.joinDisabledReason = null;
        this.delayedOperation = null;
    }

    protected AbstractTypedTable(AbstractTypedTable<E> base, String joinDisabledReason) {
        this.immutableType = base.immutableType;
        this.raw = base.raw;
        this.delayedOperation = base.delayedOperation;
        this.joinDisabledReason = joinDisabledReason != null ? joinDisabledReason : base.joinDisabledReason;
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.immutableType;
    }

    @Override
    public Predicate eq(Table<E> other) {
        if (this.raw != null) {
            return this.raw.eq(other);
        }
        if (other.getImmutableType() != this.immutableType) {
            throw new IllegalArgumentException("Cannot compare tables of different types");
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).eq(other.get(idPropName));
    }

    @Override
    public Predicate isNull() {
        if (this.raw != null) {
            return this.raw.isNull();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNull();
    }

    @Override
    public Predicate isNotNull() {
        if (this.raw != null) {
            return this.raw.isNotNull();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        if (this.raw != null) {
            return this.raw.count();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).count();
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        if (this.raw != null) {
            return this.raw.count();
        }
        String idPropName = this.immutableType.getIdProp().getName();
        return this.get(idPropName).count();
    }

    @Override
    public <XE extends Expression<?>> XE get(String prop) {
        if (this.raw != null) {
            return this.raw.get(prop);
        }
        ImmutableProp immutableProp = this.immutableType.getProp(prop);
        return (XE)PropExpressionImpl.of(this, immutableProp);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.join(prop);
        }
        return (XT)TableProxies.fluent(new DelayJoin(this, this.immutableType.getProp(prop), JoinType.INNER, null));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.join(prop, joinType);
        }
        return (XT)TableProxies.fluent(new DelayJoin(this, this.immutableType.getProp(prop), joinType, null));
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.join(prop, joinType, treatedAs);
        }
        return (XT)TableProxies.fluent(new DelayJoin(this, this.immutableType.getProp(prop), joinType, treatedAs));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop, JoinType.INNER));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop, joinType);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop, joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop.unwrap(), JoinType.INNER));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(prop, joinType);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, prop.unwrap(), joinType));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(targetTableType, backPropBlock);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, ImmutableProps.join(targetTableType, backPropBlock), JoinType.INNER));
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        if (this.raw != null) {
            this.__beforeJoin();
            return this.raw.inverseJoin(targetTableType, backPropBlock, joinType);
        }
        return (XT)TableProxies.fluent(new DelayInverseJoin(this, ImmutableProps.join(targetTableType, backPropBlock), joinType));
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        if (this.raw != null) {
            return this.raw.fetch(fetcher);
        }
        return new FetcherSelectionImpl<E>(this, fetcher);
    }

    @Override
    public Table<?> __parent() {
        if (this.raw != null) {
            return this.raw.getParent();
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.parent();
        }
        return null;
    }

    @Override
    public ImmutableProp __prop() {
        if (this.raw != null) {
            return this.raw.getJoinProp();
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.prop();
        }
        return null;
    }

    @Override
    public TableImplementor<E> __unwrap() {
        return this.raw;
    }

    @Override
    public TableImplementor<E> __resolve(RootTableResolver resolver) {
        if (this.raw != null) {
            return this.raw;
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.resolve(resolver);
        }
        if (resolver == null) {
            throw new IllegalArgumentException("resolver cannot be null when the table proxy is not wrapper");
        }
        return resolver.resolveRootTable(this);
    }

    protected void __beforeJoin() {
        if (this.joinDisabledReason != null) {
            throw new IllegalStateException("Table join is disabled because " + this.joinDisabledReason);
        }
    }

    protected boolean __isFluentRoot() {
        return this.raw == null && this.delayedOperation == null && this.delayedOperation == null;
    }

    public String toString() {
        if (this.raw != null) {
            return this.raw.toString();
        }
        if (this.delayedOperation != null) {
            return this.delayedOperation.toString();
        }
        return this.immutableType.toString();
    }

    protected <X> DelayedOperation<X> joinOperation(String prop) {
        return new DelayJoin(this, this.immutableType.getProp(prop), JoinType.INNER, null);
    }

    protected <X> DelayedOperation<X> joinOperation(String prop, JoinType joinType) {
        return new DelayJoin(this, this.immutableType.getProp(prop), joinType, null);
    }

    protected <X> DelayedOperation<X> joinOperation(String prop, JoinType joinType, ImmutableType treatedAs) {
        return new DelayJoin(this, this.immutableType.getProp(prop), joinType, treatedAs);
    }

    public static interface DelayedOperation<E> {
        public Table<?> parent();

        public ImmutableProp prop();

        public ImmutableType targetType();

        public TableImplementor<E> resolve(RootTableResolver var1);
    }

    private static class DelayJoin<E>
    implements DelayedOperation<E> {
        private final AbstractTypedTable<?> parent;
        private final ImmutableProp prop;
        private final JoinType joinType;
        private final ImmutableType treatedAs;

        private DelayJoin(AbstractTypedTable<?> parent, ImmutableProp prop, JoinType joinType, ImmutableType treatedAs) {
            this.parent = parent;
            this.joinType = joinType;
            this.treatedAs = treatedAs;
            this.prop = treatedAs != null ? RedirectedProp.target((ImmutableProp)prop, (ImmutableType)treatedAs) : prop;
        }

        @Override
        public Table<?> parent() {
            return this.parent;
        }

        @Override
        public ImmutableProp prop() {
            return this.prop;
        }

        @Override
        public ImmutableType targetType() {
            return this.treatedAs != null ? this.treatedAs : this.prop.getTargetType();
        }

        @Override
        public TableImplementor<E> resolve(RootTableResolver ctx) {
            return this.parent.__resolve(ctx).joinImplementor(this.prop.getName(), this.joinType, this.treatedAs);
        }

        public String toString() {
            return this.prop.toString();
        }
    }

    private static class DelayInverseJoin<E>
    implements DelayedOperation<E> {
        private final AbstractTypedTable<?> parent;
        private final ImmutableProp prop;
        private final JoinType joinType;

        private DelayInverseJoin(AbstractTypedTable<?> parent, ImmutableProp prop, JoinType joinType) {
            this.parent = parent;
            this.prop = prop;
            this.joinType = joinType;
        }

        @Override
        public Table<?> parent() {
            return this.parent;
        }

        @Override
        public ImmutableProp prop() {
            return this.prop;
        }

        @Override
        public ImmutableType targetType() {
            return this.prop.getDeclaringType();
        }

        @Override
        public TableImplementor<E> resolve(RootTableResolver ctx) {
            return this.parent.__resolve(ctx).inverseJoinImplementor(this.prop, this.joinType);
        }

        public String toString() {
            ImmutableProp opposite = this.prop.getOpposite();
            if (opposite != null) {
                return opposite.toString();
            }
            return this.parent + "[\u2190 " + this.prop + ']';
        }
    }
}

