/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.AbstractTypedTable;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.util.StaticCache;

public class TableProxies {
    private static final StaticCache<Class<?>, Constructor<?>> WRAPPER_CACHE = new StaticCache(TableProxies::createWrapperConstructor);
    private static final StaticCache<ImmutableType, Constructor<?>> FLUENT_CACHE = new StaticCache(TableProxies::createFluentConstructor);

    private TableProxies() {
    }

    public static <T extends TableEx<?>> T wrap(Table<?> table) {
        if (table.getImmutableType() instanceof AssociationType) {
            return (T)((TableEx)table);
        }
        Class javaClass = table.getImmutableType().getJavaClass();
        Constructor constructor = (Constructor)WRAPPER_CACHE.get((Object)javaClass);
        if (constructor == null) {
            return (T)((TableEx)table);
        }
        return (T)((TableEx)TableProxies.invokeConstructor(constructor, table));
    }

    public static <T extends Table<?>> T fluent(ImmutableType type) {
        Constructor constructor = (Constructor)FLUENT_CACHE.get((Object)type);
        return (T)((Table)TableProxies.invokeConstructor(constructor, new Object[]{null}));
    }

    public static <T extends Table<?>> T fluent(AbstractTypedTable.DelayedOperation<?> delayedOperation) {
        Constructor constructor = (Constructor)FLUENT_CACHE.get((Object)delayedOperation.targetType());
        return (T)((Table)TableProxies.invokeConstructor(constructor, delayedOperation));
    }

    private static Constructor<?> createWrapperConstructor(Class<?> javaClass) {
        return TableProxies.createConstructor(ImmutableType.get(javaClass), new Class[]{TableImplementor.class});
    }

    private static Constructor<?> createFluentConstructor(ImmutableType type) {
        if (type instanceof AssociationType) {
            throw new IllegalStateException("\"" + type + "\" cannot be AssociationType");
        }
        return TableProxies.createConstructor(type, new Class[]{AbstractTypedTable.DelayedOperation.class});
    }

    private static Constructor<?> createConstructor(ImmutableType type, Class<?>[] parameterTypes) {
        Class<?> tableClass;
        try {
            tableClass = Class.forName(type.getJavaClass().getName() + "TableEx", true, type.getJavaClass().getClassLoader());
        }
        catch (ClassNotFoundException ex) {
            return null;
        }
        if (!AbstractTypedTable.class.isAssignableFrom(tableClass)) {
            throw new ModelException("\"" + tableClass + "\" is not derived type of \"" + AbstractTypedTable.class.getName() + "\"");
        }
        try {
            return tableClass.getConstructor(parameterTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ModelException("\"" + tableClass + "\" dose not have constructor whose argument types are \"" + TableImplementor.class.getName() + "\" and \"" + String.class.getName() + "\"");
        }
    }

    private static <T> T invokeConstructor(Constructor<?> constructor, Object ... args) {
        if (constructor == null) {
            throw new IllegalStateException("There is no constructor whose parameter list \"(" + AbstractTypedTable.class.getName() + ", " + AbstractTypedTable.DelayedOperation.class.getName() + ")\"");
        }
        try {
            return (T)constructor.newInstance(args);
        }
        catch (IllegalAccessException | InstantiationException ex) {
            throw new AssertionError((Object)("Internal bug: Can not create instance of " + constructor.getDeclaringClass().getName()));
        }
        catch (InvocationTargetException ex) {
            Throwable target = ex.getTargetException();
            if (target instanceof RuntimeException) {
                throw (RuntimeException)target;
            }
            if (target instanceof Error) {
                throw (Error)target;
            }
            throw new AssertionError((Object)("Internal bug: Can not create instance of " + constructor.getDeclaringClass().getName()));
        }
    }

    public static <E> TableImplementor<E> resolve(Table<E> table, RootTableResolver resolver) {
        if (table instanceof TableImplementor) {
            return (TableImplementor)table;
        }
        if (table instanceof TableProxy) {
            return ((TableProxy)table).__resolve(resolver);
        }
        throw new IllegalArgumentException("Unknown table implementation");
    }
}

