/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.List;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstContext;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.PaginationContextImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.impl.table.TableSelection;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class AbstractConfigurableTypedQueryImpl
implements TypedQueryImplementor {
    private TypedQueryData data;
    private AbstractMutableQueryImpl baseQuery;

    public AbstractConfigurableTypedQueryImpl(TypedQueryData data, AbstractMutableQueryImpl baseQuery) {
        this.data = data;
        this.baseQuery = baseQuery;
    }

    public AbstractMutableQueryImpl getBaseQuery() {
        return this.baseQuery;
    }

    public TypedQueryData getData() {
        return this.data;
    }

    @Override
    public List<Selection<?>> getSelections() {
        return this.data.getSelections();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(@NotNull AstVisitor visitor) {
        AstContext astContext = visitor.getAstContext();
        astContext.pushStatement(this.getBaseQuery());
        try {
            for (Selection<?> selection : this.data.getSelections()) {
                Ast.from(selection, visitor.getAstContext()).accept(visitor);
            }
            this.baseQuery.accept(visitor, this.data.getOldSelections(), this.data.isWithoutSortingAndPaging());
        }
        finally {
            astContext.popStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        AstContext astContext = builder.getAstContext();
        astContext.pushStatement(this.getBaseQuery());
        try {
            if (this.data.isWithoutSortingAndPaging() || this.data.getLimit() == Integer.MAX_VALUE) {
                this.renderWithoutPaging(builder);
            } else {
                SqlBuilder subBuilder = builder.createChildBuilder();
                this.renderWithoutPaging(subBuilder);
                subBuilder.build(result -> {
                    PaginationContextImpl ctx = new PaginationContextImpl(this.data.getLimit(), this.data.getOffset(), (String)result.get_1(), (List)result.get_2());
                    this.baseQuery.getSqlClient().getDialect().paginate(ctx);
                    return ctx.build();
                });
            }
            if (this.data.isForUpdate()) {
                builder.sql(" for update");
            }
        }
        finally {
            astContext.popStatement();
        }
    }

    private void renderWithoutPaging(SqlBuilder builder) {
        builder.sql("select ");
        if (this.data.isDistinct()) {
            builder.sql("distinct ");
        }
        String separator = "";
        for (Selection<?> selection : this.data.getSelections()) {
            TableImplementor tableSelection;
            builder.sql(separator);
            if (selection instanceof TableSelection) {
                tableSelection = (TableImplementor)selection;
                AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
            } else if (selection instanceof Table) {
                tableSelection = TableProxies.resolve((Table)selection, builder.getAstContext());
                AbstractConfigurableTypedQueryImpl.renderAllProps(tableSelection, builder);
            } else {
                Ast.from(selection, builder.getAstContext()).renderTo(builder);
            }
            separator = ", ";
        }
        this.baseQuery.renderTo(builder, this.data.isWithoutSortingAndPaging());
    }

    private static void renderAllProps(TableSelection table, SqlBuilder builder) {
        String separator = "";
        Map selectableProps = table.getImmutableType().getSelectableProps();
        for (ImmutableProp prop : selectableProps.values()) {
            builder.sql(separator);
            table.renderSelection(prop, builder);
            separator = ", ";
        }
    }
}

