/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.table.RootTableResolver;
import org.babyfish.jimmer.sql.ast.impl.table.TableImplementor;
import org.babyfish.jimmer.sql.ast.impl.table.TableProxies;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.ast.table.spi.TableProxy;
import org.babyfish.jimmer.sql.runtime.TableUsedState;

public class AstContext
implements RootTableResolver {
    private final JSqlClient sqlClient;
    private final Map<Table<?>, TableUsedState> tableUsedStateMap = new HashMap();
    private final LinkedList<AbstractMutableStatementImpl> stack = new LinkedList();

    public AstContext(JSqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    public JSqlClient getSqlClient() {
        return this.sqlClient;
    }

    public void useTableId(Table<?> table) {
        this.tableUsedStateMap.computeIfAbsent(table, t -> TableUsedState.ID_ONLY);
    }

    public void useTable(Table<?> table) {
        this.tableUsedStateMap.put(table, TableUsedState.USED);
    }

    public TableUsedState getTableUsedState(Table<?> table) {
        TableUsedState state = this.tableUsedStateMap.get(table);
        return state != null ? state : TableUsedState.NONE;
    }

    public void pushStatement(AbstractMutableStatementImpl statement) {
        this.stack.push(statement);
    }

    public void popStatement() {
        this.stack.pop();
    }

    @Override
    public <E> TableImplementor<E> resolveRootTable(Table<E> table) {
        if (table instanceof TableImplementor) {
            return (TableImplementor)table;
        }
        TableImplementor tableImplementor = ((TableProxy)table).__unwrap();
        if (tableImplementor != null) {
            return tableImplementor;
        }
        for (AbstractMutableStatementImpl statement : this.stack) {
            Object stmtTable = statement.getTable();
            if (table == stmtTable) {
                return statement.getTableImplementor();
            }
            if (!(table instanceof TableEx) || stmtTable instanceof TableEx || table != stmtTable.asTableEx()) continue;
            return statement.getTableImplementor();
        }
        if (((TableProxy)table).__parent() != null) {
            throw new IllegalArgumentException("\"" + AstContext.class.getName() + ".resolveRootTable\" only does not accept non-root table, you can use \"" + TableProxies.class.getName() + ".resolve\"");
        }
        throw new IllegalArgumentException("Cannot resolve the root table " + table);
    }

    public AbstractMutableStatementImpl getStatement() {
        return this.stack.peek();
    }
}

