/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.meta;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutablePropCategory;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.OrderedItem;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.association.Association;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.meta.Storage;
import org.jetbrains.annotations.NotNull;

public abstract class AssociationProp
implements ImmutableProp {
    final AssociationType declaringType;

    AssociationProp(AssociationType declaringType) {
        this.declaringType = declaringType;
    }

    @NotNull
    public ImmutableType getDeclaringType() {
        return this.declaringType;
    }

    @NotNull
    public ImmutablePropCategory getCategory() {
        return ImmutablePropCategory.REFERENCE;
    }

    @NotNull
    public DissociateAction getDissociateAction() {
        return DissociateAction.NONE;
    }

    public boolean isAssociation(TargetLevel level) {
        return true;
    }

    public boolean isReference(TargetLevel level) {
        return true;
    }

    public boolean isScalar() {
        return false;
    }

    public boolean isScalarList() {
        return false;
    }

    public boolean isReferenceList(TargetLevel level) {
        return false;
    }

    public boolean isNullable() {
        return false;
    }

    public Annotation getAssociationAnnotation() {
        return null;
    }

    public boolean isTransient() {
        return false;
    }

    public boolean hasTransientResolver() {
        return false;
    }

    public boolean isId() {
        return false;
    }

    public boolean isVersion() {
        return false;
    }

    public ImmutableProp getMappedBy() {
        return null;
    }

    public ImmutableProp getOpposite() {
        return null;
    }

    public List<OrderedItem> getOrderedItems() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.declaringType + "." + this.getName();
    }

    static class Target
    extends AssociationProp {
        private static final Method GETTER;
        private final Column column;

        Target(AssociationType declaringType) {
            super(declaringType);
            this.column = new Column(declaringType.getMiddleTable().getTargetJoinColumnName());
        }

        public int getId() {
            return 2;
        }

        @NotNull
        public String getName() {
            return "target";
        }

        @NotNull
        public Class<?> getElementClass() {
            return this.declaringType.getTargetType().getJavaClass();
        }

        public ImmutableType getTargetType() {
            return this.declaringType.getTargetType();
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return GETTER.getAnnotation(annotationType);
        }

        public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
            return GETTER.getAnnotationsByType(annotationType);
        }

        public <S extends Storage> S getStorage() {
            return (S)this.column;
        }

        static {
            try {
                GETTER = Association.class.getMethod("target", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new AssertionError((Object)"Internal bug: Cannot get Association.source");
            }
        }
    }

    static class Source
    extends AssociationProp {
        private static final Method GETTER;
        private final Column column;

        Source(AssociationType declaringType) {
            super(declaringType);
            this.column = new Column(declaringType.getMiddleTable().getJoinColumnName());
        }

        public int getId() {
            return 1;
        }

        @NotNull
        public String getName() {
            return "source";
        }

        @NotNull
        public Class<?> getElementClass() {
            return this.declaringType.getSourceType().getJavaClass();
        }

        public ImmutableType getTargetType() {
            return this.declaringType.getSourceType();
        }

        public <A extends Annotation> A getAnnotation(Class<A> annotationType) {
            return GETTER.getAnnotation(annotationType);
        }

        public <A extends Annotation> A[] getAnnotations(Class<A> annotationType) {
            return GETTER.getAnnotationsByType(annotationType);
        }

        public <S extends Storage> S getStorage() {
            return (S)this.column;
        }

        static {
            try {
                GETTER = Association.class.getMethod("source", new Class[0]);
            }
            catch (NoSuchMethodException ex) {
                throw new AssertionError((Object)"Internal bug: Cannot get Association.source");
            }
        }
    }
}

