/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fetcher.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.query.ConfigurableSubQuery;
import org.babyfish.jimmer.sql.ast.query.MutableSubQuery;
import org.babyfish.jimmer.sql.ast.query.Order;
import org.babyfish.jimmer.sql.ast.query.Sortable;
import org.babyfish.jimmer.sql.ast.table.AssociationTableEx;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.fetcher.FieldFilterArgs;

public class FieldFilterArgsImpl<T extends Table<?>>
implements FieldFilterArgs<T> {
    private final AbstractMutableQueryImpl query;
    private final T table;
    private final Collection<Object> keys;

    public static <T extends Table<?>> FieldFilterArgs<T> of(AbstractMutableQueryImpl query, T table, Collection<Object> keys) {
        return new FieldFilterArgsImpl<T>(query, table, Objects.requireNonNull(keys, "keys cannot be null"));
    }

    private FieldFilterArgsImpl(AbstractMutableQueryImpl query, T table, Collection<Object> keys) {
        this.query = query;
        this.table = table;
        this.keys = keys != null ? Collections.unmodifiableCollection(keys) : null;
    }

    @Override
    public T getTable() {
        return this.table;
    }

    @Override
    public <K> K getKey() {
        if (this.keys.size() > 1) {
            throw new IllegalStateException("Too much keys");
        }
        return (K)this.keys.iterator().next();
    }

    @Override
    public <K> Collection<K> getKeys() {
        return this.keys;
    }

    @Override
    public Sortable where(Predicate ... predicates) {
        return this.query.where(predicates);
    }

    @Override
    public Sortable orderBy(Expression<?> ... expressions) {
        return this.query.orderBy((Expression[])expressions);
    }

    @Override
    public Sortable orderBy(Order ... orders) {
        return this.query.orderBy(orders);
    }

    public <X extends Table<?>, R> ConfigurableSubQuery<R> createSubQuery(Class<X> tableType, BiFunction<MutableSubQuery, X, ConfigurableSubQuery<R>> block) {
        return this.query.createSubQuery(tableType, block);
    }

    public <X extends Table<?>> MutableSubQuery createWildSubQuery(Class<X> tableType, BiConsumer<MutableSubQuery, X> block) {
        return this.query.createWildSubQuery(tableType, block);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>, R> ConfigurableSubQuery<R> createAssociationSubQuery(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter, BiFunction<MutableSubQuery, AssociationTableEx<SE, ST, TE, TT>, ConfigurableSubQuery<R>> block) {
        return this.query.createAssociationSubQuery(sourceTableType, targetTableGetter, block);
    }

    @Override
    public <SE, ST extends TableEx<SE>, TE, TT extends TableEx<TE>, R> MutableSubQuery createAssociationWildSubQuery(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter, BiConsumer<MutableSubQuery, AssociationTableEx<SE, ST, TE, TT>> block) {
        return this.query.createAssociationWildSubQuery(sourceTableType, targetTableGetter, block);
    }

    public AbstractMutableQueryImpl unwrap() {
        return this.query;
    }
}

