/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache.chain;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.function.Supplier;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.chain.CacheChain;
import org.babyfish.jimmer.sql.cache.chain.LoadingBinder;
import org.babyfish.jimmer.sql.cache.chain.SimpleBinder;
import org.jetbrains.annotations.NotNull;

class ChainCacheImpl<K, V>
implements Cache<K, V> {
    private static final ThreadLocal<CacheLoader<?, ?>> LOADER_LOCAL = new ThreadLocal();
    protected final Node<K, V> node;

    public ChainCacheImpl(List<Object> binders) {
        if (binders.isEmpty()) {
            throw new IllegalArgumentException("binders cannot be empty");
        }
        Node<K, V> node = this.createTailNode();
        ListIterator<Object> itr = binders.listIterator(binders.size());
        while (itr.hasPrevious()) {
            Object binder = itr.previous();
            node = this.createNode(binder, node);
        }
        this.node = node;
    }

    @Override
    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> keys, @NotNull CacheEnvironment<K, V> env) {
        return ChainCacheImpl.usingCacheLoading(env.getLoader(), () -> this.node.loadAll(keys));
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys, Object reason) {
        this.node.deleteAll(keys, reason);
    }

    protected Node<K, V> createNode(Object binder, Node<K, V> next) {
        if (binder instanceof LoadingBinder) {
            return new LoadingNode<K, V>((LoadingBinder)binder, next);
        }
        return new SimpleNode<K, V>((SimpleBinder)binder, next);
    }

    protected TailNode<K, V> createTailNode() {
        return new TailNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static <R> R usingCacheLoading(CacheLoader<?, ?> loader, Supplier<R> block) {
        if (loader == null) {
            throw new IllegalArgumentException("loader cannot be null");
        }
        CacheLoader<?, ?> oldLoader = LOADER_LOCAL.get();
        LOADER_LOCAL.set(loader);
        try {
            R r = block.get();
            return r;
        }
        finally {
            if (oldLoader != null) {
                LOADER_LOCAL.set(oldLoader);
            } else {
                LOADER_LOCAL.remove();
            }
        }
    }

    protected static <K, V> CacheLoader<K, V> currentCacheLoader() {
        CacheLoader<?, ?> loader = LOADER_LOCAL.get();
        if (loader == null) {
            throw new IllegalStateException("Cache binder can only be called by chain cache");
        }
        return loader;
    }

    protected static class TailNode<K, V>
    implements Node<K, V> {
        protected TailNode() {
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            CacheLoader loader = ChainCacheImpl.currentCacheLoader();
            return loader.loadAll(keys);
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
        }
    }

    protected static interface Node<K, V>
    extends CacheChain<K, V> {
        public void deleteAll(@NotNull Collection<K> var1, Object var2);
    }

    private static class LoadingNode<K, V>
    implements Node<K, V> {
        private final LoadingBinder<K, V> binder;
        private final Node<K, V> next;

        LoadingNode(LoadingBinder<K, V> binder, Node<K, V> next) {
            this.binder = binder;
            this.next = next;
            binder.initialize(next);
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            return this.binder.getAll(keys);
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
            this.next.deleteAll(keys, reason);
            this.binder.deleteAll(keys, reason);
        }
    }

    protected static class SimpleNode<K, V>
    implements Node<K, V> {
        protected final SimpleBinder<K, V> binder;
        protected final Node<K, V> next;

        protected SimpleNode(SimpleBinder<K, V> binder, Node<K, V> next) {
            this.binder = binder;
            this.next = next;
        }

        @Override
        @NotNull
        public Map<K, V> loadAll(@NotNull Collection<K> keys) {
            Map map = this.binder.getAll(keys);
            if (map.size() < keys.size()) {
                LinkedHashSet<K> missedKeys = new LinkedHashSet<K>();
                for (K key : keys) {
                    if (map.containsKey(key)) continue;
                    missedKeys.add(key);
                }
                Map mapFromNext = this.next.loadAll(missedKeys);
                if (mapFromNext.size() < missedKeys.size()) {
                    for (Object missedKey : missedKeys) {
                        if (mapFromNext.containsKey(missedKey)) continue;
                        mapFromNext.put(missedKey, null);
                    }
                }
                this.binder.setAll(mapFromNext);
                map.putAll(mapFromNext);
            }
            return map;
        }

        @Override
        public void deleteAll(@NotNull Collection<K> keys, Object reason) {
            this.next.deleteAll(keys, reason);
            this.binder.deleteAll(keys, reason);
        }
    }
}

