/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.table;

import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.TableImpl;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fetcher.Field;
import org.babyfish.jimmer.sql.fetcher.impl.FetcherSelection;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;
import org.jetbrains.annotations.NotNull;

class FetcherSelectionImpl<E>
implements FetcherSelection<E>,
Ast {
    private final TableImpl<E> table;
    private final Fetcher<E> fetcher;

    FetcherSelectionImpl(TableImpl<E> table, Fetcher<E> fetcher) {
        this.table = table;
        this.fetcher = fetcher;
    }

    @Override
    public Fetcher<E> getFetcher() {
        return this.fetcher;
    }

    @Override
    public void accept(@NotNull AstVisitor visitor) {
        for (Field field : this.fetcher.getFieldMap().values()) {
            ImmutableProp prop = field.getProp();
            if (!(prop.getStorage() instanceof Column)) continue;
            visitor.visitTableReference(this.table, prop);
        }
    }

    @Override
    public void renderTo(@NotNull SqlBuilder builder) {
        String separator = "";
        for (Field field : this.fetcher.getFieldMap().values()) {
            ImmutableProp prop = field.getProp();
            if (!(prop.getStorage() instanceof Column)) continue;
            builder.sql(separator);
            separator = ", ";
            builder.sql(this.table.getAlias()).sql(".").sql(((Column)prop.getStorage()).getName());
        }
    }

    public String toString() {
        return "TableFetcherSelection{fetcher=" + this.fetcher + '}';
    }
}

