/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.sql.Connection;
import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.Ast;
import org.babyfish.jimmer.sql.ast.impl.AstVisitor;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractConfigurableTypedQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.AbstractMutableQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MergedTypedRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.TypedQueryData;
import org.babyfish.jimmer.sql.ast.impl.query.TypedRootQueryImplementor;
import org.babyfish.jimmer.sql.ast.impl.query.UseTableVisitor;
import org.babyfish.jimmer.sql.ast.impl.table.TableWrappers;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.query.TypedRootQuery;
import org.babyfish.jimmer.sql.ast.query.TypedSubQuery;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.runtime.Selectors;
import org.babyfish.jimmer.sql.runtime.SqlBuilder;

public class ConfigurableRootQueryImpl<T extends Table<?>, R>
extends AbstractConfigurableTypedQueryImpl<R>
implements ConfigurableRootQuery<T, R>,
TypedRootQueryImplementor<R> {
    public ConfigurableRootQueryImpl(TypedQueryData data, MutableRootQueryImpl<T> baseQuery) {
        super(data, baseQuery);
    }

    @Override
    public MutableRootQueryImpl<T> getBaseQuery() {
        return (MutableRootQueryImpl)super.getBaseQuery();
    }

    @Override
    public <X> ConfigurableRootQuery<T, X> reselect(BiFunction<MutableRootQuery<T>, T, ConfigurableRootQuery<T, X>> block) {
        if (this.getData().getOldSelections() != null) {
            throw new IllegalStateException("The current query has been reselected, it cannot be reselect again");
        }
        if (this.getBaseQuery().isGroupByClauseUsed()) {
            throw new IllegalStateException("The current query uses group by clause, it cannot be reselected");
        }
        ReselectValidator visitor = new ReselectValidator();
        for (Selection<?> selection : this.getData().getSelections()) {
            if (selection instanceof Table) {
                TableWrappers.unwrap((Table)selection).accept(visitor);
                continue;
            }
            ((Ast)((Object)selection)).accept(visitor);
        }
        ConfigurableRootQuery<T, X> reselected = block.apply((MutableRootQuery<AbstractMutableQueryImpl>)((Object)this.getBaseQuery()), (AbstractMutableQueryImpl)this.getBaseQuery().getTable());
        List<Selection<?>> selections = ((ConfigurableRootQueryImpl)reselected).getData().getSelections();
        return new ConfigurableRootQueryImpl<T, R>(this.getData().reselect(selections), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> distinct() {
        TypedQueryData data = this.getData();
        if (data.isDistinct()) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.distinct(), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> limit(int limit, int offset) {
        TypedQueryData data = this.getData();
        if (data.getLimit() == limit && data.getOffset() == offset) {
            return this;
        }
        if (limit < 0) {
            throw new IllegalArgumentException("'limit' can not be less than 0");
        }
        if (offset < 0) {
            throw new IllegalArgumentException("'offset' can not be less than 0");
        }
        if (limit > Integer.MAX_VALUE - offset) {
            throw new IllegalArgumentException("'limit' > Int.MAX_VALUE - offset");
        }
        return new ConfigurableRootQueryImpl<T, R>(data.limit(limit, offset), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> withoutSortingAndPaging() {
        TypedQueryData data = this.getData();
        if (data.isWithoutSortingAndPaging()) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.withoutSortingAndPaging(), this.getBaseQuery());
    }

    @Override
    public ConfigurableRootQuery<T, R> forUpdate() {
        TypedQueryData data = this.getData();
        if (data.isForUpdate()) {
            return this;
        }
        return new ConfigurableRootQueryImpl<T, R>(data.forUpdate(), this.getBaseQuery());
    }

    @Override
    public List<R> execute() {
        return this.getBaseQuery().getSqlClient().getSlaveConnectionManager(this.getData().isForUpdate()).execute(this::executeImpl);
    }

    @Override
    public List<R> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        return this.getBaseQuery().getSqlClient().getSlaveConnectionManager(this.getData().isForUpdate()).execute(this::executeImpl);
    }

    private List<R> executeImpl(Connection con) {
        TypedQueryData data = this.getData();
        if (data.getLimit() == 0) {
            return Collections.emptyList();
        }
        JSqlClient sqlClient = this.getBaseQuery().getSqlClient();
        Tuple2<String, List<Object>> sqlResult = this.preExecute(new SqlBuilder(sqlClient));
        return Selectors.select(sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), data.getSelections(), this.getBaseQuery().getPurpose());
    }

    @Override
    public void forEach(Connection con, int batchSize, Consumer<R> consumer) {
        int finalBatchSize;
        TypedQueryData data = this.getData();
        if (data.getLimit() == 0) {
            return;
        }
        JSqlClient sqlClient = this.getBaseQuery().getSqlClient();
        int n = finalBatchSize = batchSize > 0 ? batchSize : sqlClient.getDefaultBatchSize();
        if (con != null) {
            this.forEachImpl(con, finalBatchSize, consumer);
        } else {
            sqlClient.getSlaveConnectionManager(this.getData().isForUpdate()).execute((Connection newConn) -> {
                this.forEachImpl((Connection)newConn, finalBatchSize, consumer);
                return null;
            });
        }
    }

    private void forEachImpl(Connection con, int batchSize, Consumer<R> consumer) {
        JSqlClient sqlClient = this.getBaseQuery().getSqlClient();
        Tuple2<String, List<Object>> sqlResult = this.preExecute(new SqlBuilder(sqlClient));
        Selectors.forEach(sqlClient, con, sqlResult.get_1(), sqlResult.get_2(), this.getData().getSelections(), this.getBaseQuery().getPurpose(), batchSize, consumer);
    }

    private Tuple2<String, List<Object>> preExecute(SqlBuilder builder) {
        UseTableVisitor visitor = new UseTableVisitor(builder);
        this.accept(visitor);
        this.renderTo(builder);
        return builder.build();
    }

    @Override
    public TypedRootQuery<R> union(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union", this, other);
    }

    @Override
    public TypedRootQuery<R> unionAll(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "union all", this, other);
    }

    @Override
    public TypedRootQuery<R> minus(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "minus", this, other);
    }

    @Override
    public TypedRootQuery<R> intersect(TypedRootQuery<R> other) {
        return new MergedTypedRootQueryImpl<R>(this.getBaseQuery().getSqlClient(), "intersect", this, other);
    }

    @Override
    public boolean isForUpdate() {
        return this.getData().isForUpdate();
    }

    private static class ReselectValidator
    extends AstVisitor {
        ReselectValidator() {
            super(null);
        }

        @Override
        public boolean visitSubQuery(TypedSubQuery<?> subQuery) {
            return false;
        }

        @Override
        public void visitAggregation(String functionName, Expression<?> expression, String prefix) {
            throw new IllegalStateException("The current query uses aggregation function in select clause, it cannot be reselected");
        }
    }
}

