/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.Entity;
import org.reflections.Configuration;
import org.reflections.Reflections;
import org.reflections.util.ConfigurationBuilder;

public class EntityManager {
    private final Map<ImmutableType, ImmutableTypeInfo> map;

    public EntityManager(ClassLoader classLoader, String ... packageNames) {
        this(EntityManager.scan(classLoader, packageNames));
    }

    public EntityManager(Class<?> ... classes) {
        this(Arrays.asList(classes));
    }

    public EntityManager(Collection<Class<?>> classes) {
        if (classes.isEmpty()) {
            throw new IllegalArgumentException("classes cannot be empty");
        }
        LinkedHashMap<ImmutableType, ImmutableTypeInfo> map = new LinkedHashMap<ImmutableType, ImmutableTypeInfo>();
        for (Class<?> clazz : classes) {
            if (clazz == null) continue;
            ImmutableType immutableType = ImmutableType.get(clazz);
            if (!immutableType.isEntity()) {
                throw new IllegalArgumentException("\"" + immutableType + "\" is not entity");
            }
            map.put(immutableType, new ImmutableTypeInfo());
            for (immutableType = immutableType.getSuperType(); immutableType != null && (immutableType.isEntity() || immutableType.isMappedSuperclass()); immutableType = immutableType.getSuperType()) {
                map.put(immutableType, new ImmutableTypeInfo());
            }
        }
        for (Map.Entry entry : map.entrySet()) {
            ImmutableType type = (ImmutableType)entry.getKey();
            ImmutableTypeInfo info = (ImmutableTypeInfo)entry.getValue();
            if (type.isMappedSuperclass()) {
                for (ImmutableType otherType : map.keySet()) {
                    if (!this.isImplementationType(type, otherType)) continue;
                    info.implementationTypes.add(otherType);
                }
                continue;
            }
            for (ImmutableType otherType : map.keySet()) {
                if (type == otherType || !type.isAssignableFrom(otherType)) continue;
                info.allDerivedTypes.add(otherType);
                if (type != otherType.getSuperType()) continue;
                info.directDerivedTypes.add(otherType);
            }
        }
        for (ImmutableTypeInfo immutableTypeInfo : map.values()) {
            immutableTypeInfo.implementationTypes = Collections.unmodifiableList(immutableTypeInfo.implementationTypes);
            immutableTypeInfo.directDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.directDerivedTypes);
            immutableTypeInfo.allDerivedTypes = Collections.unmodifiableList(immutableTypeInfo.allDerivedTypes);
        }
        this.map = Collections.unmodifiableMap(map);
    }

    private static Collection<Class<?>> scan(ClassLoader classLoader, String ... packageNames) {
        Reflections reflections = new Reflections((Configuration)new ConfigurationBuilder().addClassLoaders(new ClassLoader[]{classLoader}).forPackages(packageNames));
        List<Class<?>> entityTypes = reflections.getTypesAnnotatedWith(Entity.class).stream().filter(it -> it.isInterface() && it.isAnnotationPresent(Entity.class)).collect(Collectors.toList());
        if (entityTypes.isEmpty()) {
            throw new IllegalArgumentException("No entity class is found in the package \"" + Arrays.toString(packageNames) + "\" by the specified class loader");
        }
        return entityTypes;
    }

    public Set<ImmutableType> getAllTypes() {
        return this.map.keySet();
    }

    public List<ImmutableType> getImplementationTypes(ImmutableType type) {
        ImmutableTypeInfo info = this.map.get(type);
        return info != null ? info.implementationTypes : Collections.emptyList();
    }

    public List<ImmutableType> getDirectDerivedTypes(ImmutableType type) {
        ImmutableTypeInfo info = this.map.get(type);
        return info != null ? info.directDerivedTypes : Collections.emptyList();
    }

    public List<ImmutableType> getAllDerivedTypes(ImmutableType type) {
        ImmutableTypeInfo info = this.map.get(type);
        return info != null ? info.allDerivedTypes : Collections.emptyList();
    }

    private boolean isImplementationType(ImmutableType mappedSuperClass, ImmutableType type) {
        if (!mappedSuperClass.isMappedSuperclass()) {
            throw new AssertionError((Object)"Internal bug");
        }
        if (!type.isEntity()) {
            return false;
        }
        if (!mappedSuperClass.isAssignableFrom(type)) {
            return false;
        }
        return type.getSuperType().isMappedSuperclass();
    }

    private static class ImmutableTypeInfo {
        List<ImmutableType> implementationTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> directDerivedTypes = new ArrayList<ImmutableType>();
        List<ImmutableType> allDerivedTypes = new ArrayList<ImmutableType>();

        private ImmutableTypeInfo() {
        }
    }
}

