/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.fluent.impl;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.AbstractMutableStatementImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableDeleteImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.MutableUpdateImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.impl.query.MutableSubQueryImpl;
import org.babyfish.jimmer.sql.ast.query.Filterable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.fluent.Fluent;
import org.babyfish.jimmer.sql.fluent.FluentDelete;
import org.babyfish.jimmer.sql.fluent.FluentRootQuery;
import org.babyfish.jimmer.sql.fluent.FluentSubQuery;
import org.babyfish.jimmer.sql.fluent.FluentTable;
import org.babyfish.jimmer.sql.fluent.FluentUpdate;
import org.babyfish.jimmer.sql.fluent.impl.FluentDeleteImpl;
import org.babyfish.jimmer.sql.fluent.impl.FluentRootQueryImpl;
import org.babyfish.jimmer.sql.fluent.impl.FluentSubQueryImpl;
import org.babyfish.jimmer.sql.fluent.impl.FluentUpdateImpl;
import org.babyfish.jimmer.sql.runtime.ExecutionPurpose;

public class FluentImpl
implements Fluent {
    private final JSqlClient sqlClient;
    private final List<Filterable> stack = new LinkedList<Filterable>();

    public FluentImpl(JSqlClient sqlClient) {
        this.sqlClient = sqlClient;
    }

    @Override
    public <T extends FluentTable<?>> FluentRootQuery<T> query(T table) {
        Objects.requireNonNull(table);
        if (table instanceof TableEx) {
            throw new IllegalArgumentException("Top-level query does not accept TableEx");
        }
        if (!this.stack.isEmpty()) {
            throw new IllegalArgumentException("Top-level query cannot be created inside another statement");
        }
        ImmutableType immutableType = ImmutableType.get(table.getClass());
        MutableRootQueryImpl query = new MutableRootQueryImpl(this.sqlClient, immutableType, ExecutionPurpose.QUERY, false);
        table.bind(query.getTable());
        this.stack.add(query);
        return new FluentRootQueryImpl(query, () -> this.pop(query));
    }

    @Override
    public FluentSubQuery subQuery(FluentTable<?> table) {
        Objects.requireNonNull(table);
        if (this.stack.isEmpty()) {
            throw new IllegalArgumentException("No parent can be found in fluent");
        }
        Filterable parent = this.stack.get(this.stack.size() - 1);
        ImmutableType immutableType = ImmutableType.get(table.getClass());
        MutableSubQueryImpl subQuery = new MutableSubQueryImpl((AbstractMutableStatementImpl)parent, immutableType);
        table.bind((Table<?>)subQuery.getTable());
        this.stack.add(subQuery);
        return new FluentSubQueryImpl(subQuery, () -> this.pop(subQuery));
    }

    @Override
    public FluentUpdate update(FluentTable<?> table) {
        Objects.requireNonNull(table);
        if (!this.stack.isEmpty()) {
            throw new IllegalArgumentException("Update statement cannot be created inside another statement");
        }
        ImmutableType immutableType = ImmutableType.get(table.getClass());
        MutableUpdateImpl update = new MutableUpdateImpl(this.sqlClient, immutableType);
        table.bind((Table<?>)update.getTable());
        this.stack.add(update);
        return new FluentUpdateImpl(update, () -> this.pop(update));
    }

    @Override
    public FluentDelete delete(FluentTable<?> table) {
        Objects.requireNonNull(table);
        if (!this.stack.isEmpty()) {
            throw new IllegalArgumentException("Delete statement cannot be created inside another statement");
        }
        ImmutableType immutableType = ImmutableType.get(table.getClass());
        MutableDeleteImpl delete = new MutableDeleteImpl(this.sqlClient, immutableType);
        table.bind((Table<?>)delete.getTable());
        this.stack.add(delete);
        return new FluentDeleteImpl(delete, () -> this.pop(delete));
    }

    private void pop(AbstractMutableStatementImpl statement) {
        if (this.stack.get(this.stack.size() - 1) != statement) {
            throw new IllegalStateException("Nested sub query is not frozen");
        }
        this.stack.remove(this.stack.size() - 1);
    }
}

