/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.mutation;

import java.util.Collections;
import java.util.Map;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.MutationResult;

public class AbstractMutationResult
implements MutationResult {
    protected int totalAffectedRowCount;
    protected Map<AffectedTable, Integer> affectedRowCountMap;

    public AbstractMutationResult(Map<AffectedTable, Integer> affectedRowCountMap) {
        this.affectedRowCountMap = Collections.unmodifiableMap(affectedRowCountMap);
        int totalAffectedRowCount = 0;
        for (Integer affectedRowCount : affectedRowCountMap.values()) {
            totalAffectedRowCount += affectedRowCount.intValue();
        }
        this.totalAffectedRowCount = totalAffectedRowCount;
    }

    @Override
    public int getTotalAffectedRowCount() {
        return this.totalAffectedRowCount;
    }

    @Override
    public Map<AffectedTable, Integer> getAffectedRowCountMap() {
        return this.affectedRowCountMap;
    }

    @Override
    public int getAffectedRowCount(AffectedTable affectTable) {
        Integer affectedRowCount = this.affectedRowCountMap.get(affectTable);
        return affectedRowCount != null ? affectedRowCount : 0;
    }
}

