/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.LikeMode;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.StringExpression;
import org.babyfish.jimmer.sql.ast.impl.query.MutableRootQueryImpl;
import org.babyfish.jimmer.sql.ast.query.Example;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.Column;

public class ExampleImpl<E>
implements Example<E> {
    private final ImmutableSpi spi;
    private final ExampleImpl<E> prev;
    private final ImmutableProp prop;
    private final boolean likeInsensitive;
    private final LikeMode likeMode;

    public ExampleImpl(E obj) {
        if (!(obj instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("example must be immutable instance");
        }
        this.spi = (ImmutableSpi)obj;
        for (ImmutableProp prop : this.spi.__type().getProps().values()) {
            if (!this.spi.__isLoaded(prop.getId()) || prop.getStorage() instanceof Column) continue;
            throw new IllegalArgumentException("The prop \"" + prop + "\" of example object cannot be loaded, example object does not accept properties not based on simple column");
        }
        this.prev = null;
        this.prop = null;
        this.likeInsensitive = false;
        this.likeMode = LikeMode.ANYWHERE;
    }

    private ExampleImpl(ExampleImpl<E> prev, TypedProp.Scalar<E, String> prop, boolean likeInsensitive, LikeMode likeMode) {
        this.spi = prev.spi;
        this.prev = prev;
        this.prop = Objects.requireNonNull(prop, "prop cannot be null").unwrap();
        this.likeInsensitive = likeInsensitive;
        this.likeMode = Objects.requireNonNull(likeMode, "likeMode cannot be null");
    }

    @Override
    public ExampleImpl<E> like(TypedProp.Scalar<E, String> prop, LikeMode likeMode) {
        return new ExampleImpl<E>(this, prop, false, likeMode);
    }

    @Override
    public ExampleImpl<E> ilike(TypedProp.Scalar<E, String> prop, LikeMode likeMode) {
        return new ExampleImpl<E>(this, prop, true, likeMode);
    }

    ImmutableType type() {
        return this.spi.__type();
    }

    void applyTo(MutableRootQueryImpl<?> query) {
        HashMap map = new HashMap();
        this.collect(map);
        for (ImmutableProp prop : this.spi.__type().getProps().values()) {
            if (!this.spi.__isLoaded(prop.getId())) continue;
            Expression<Object> expr = ExampleImpl.expressionOf(query.getTable(), prop);
            Object value = ExampleImpl.valueOf(this.spi, prop);
            if (value == null) {
                query.where(new Predicate[]{expr.isNull()});
                continue;
            }
            ExampleImpl impl = (ExampleImpl)map.get(prop);
            if (impl == null) {
                query.where(new Predicate[]{expr.eq(value)});
                continue;
            }
            if (impl.likeInsensitive) {
                query.where(new Predicate[]{((StringExpression)expr).ilike((String)value, impl.likeMode)});
                continue;
            }
            query.where(new Predicate[]{((StringExpression)expr).like((String)value, impl.likeMode)});
        }
    }

    void collect(Map<ImmutableProp, ExampleImpl<?>> map) {
        if (this.prop != null) {
            map.putIfAbsent(this.prop, this);
        }
        if (this.prev != null) {
            this.prev.collect(map);
        }
    }

    private static Expression<Object> expressionOf(Table<?> table, ImmutableProp prop) {
        if (prop.isReference(TargetLevel.ENTITY)) {
            Object joinedExpr = table.join(prop.getName());
            return joinedExpr.get(prop.getTargetType().getIdProp().getName());
        }
        return table.get(prop.getName());
    }

    private static Object valueOf(ImmutableSpi spi, ImmutableProp prop) {
        Object value = spi.__get(prop.getId());
        if (value != null && prop.isReference(TargetLevel.ENTITY)) {
            return ((ImmutableSpi)value).__get(prop.getTargetType().getIdProp().getId());
        }
        return value;
    }
}

