/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.function.Consumer;
import org.babyfish.jimmer.sql.runtime.EnumProviderBuilder;

public abstract class ScalarProvider<T, S> {
    private Class<T> scalarType;
    private Class<S> sqlType;

    protected ScalarProvider(Class<T> scalarType, Class<S> sqlType) {
        this.scalarType = scalarType;
        this.sqlType = sqlType;
    }

    public Class<T> getScalarType() {
        return this.scalarType;
    }

    public Class<S> getSqlType() {
        return this.sqlType;
    }

    public abstract T toScalar(S var1);

    public abstract S toSql(T var1);

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType) {
        return ScalarProvider.enumProviderByString(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, String> enumProviderByString(Class<E> enumType, Consumer<EnumProviderBuilder<E, String>> block) {
        EnumProviderBuilder<Enum, String> builder = EnumProviderBuilder.of(enumType, String.class, Enum::name);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType) {
        return ScalarProvider.enumProviderByInt(enumType, null);
    }

    public static <E extends Enum<E>> ScalarProvider<E, Integer> enumProviderByInt(Class<E> enumType, Consumer<EnumProviderBuilder<E, Integer>> block) {
        EnumProviderBuilder<Enum, Integer> builder = EnumProviderBuilder.of(enumType, Integer.class, Enum::ordinal);
        if (block != null) {
            block.accept(builder);
        }
        return builder.build();
    }
}

