/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.table.spi;

import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.JoinType;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.NumericExpression;
import org.babyfish.jimmer.sql.ast.Predicate;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.table.TableWrappers;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.table.TableEx;
import org.babyfish.jimmer.sql.fetcher.Fetcher;
import org.babyfish.jimmer.sql.fluent.FluentTable;

public abstract class AbstractTableWrapper<E>
implements Table<E>,
FluentTable<E> {
    protected Table<E> _raw;

    public AbstractTableWrapper(Table<E> raw) {
        this._raw = raw;
    }

    @Override
    public void bind(Table<E> raw) {
        if (this._raw != null) {
            throw new IllegalStateException("The current table wrapper has been bound");
        }
        if (raw == null) {
            throw new IllegalArgumentException("raw cannot be null");
        }
        this._raw = TableWrappers.unwrap(raw);
    }

    @Override
    public ImmutableType getImmutableType() {
        return this.raw().getImmutableType();
    }

    @Override
    public Predicate eq(Table<E> other) {
        return this.raw().eq(other);
    }

    @Override
    public Predicate isNull() {
        return this.raw().isNull();
    }

    @Override
    public Predicate isNotNull() {
        return this.raw().isNotNull();
    }

    @Override
    public NumericExpression<Long> count() {
        return this.raw().count();
    }

    @Override
    public NumericExpression<Long> count(boolean distinct) {
        return this.raw().count(distinct);
    }

    @Override
    public <XE extends Expression<?>> XE get(String prop) {
        return this.raw().get(prop);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop) {
        return this.raw().join(prop);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType) {
        return this.raw().join(prop, joinType);
    }

    @Override
    public <XT extends Table<?>> XT join(String prop, JoinType joinType, ImmutableType treatedAs) {
        return this.raw().join(prop, joinType, treatedAs);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop) {
        return this.raw().inverseJoin(prop);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(ImmutableProp prop, JoinType joinType) {
        return this.raw().inverseJoin(prop, joinType);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop) {
        return this.raw().inverseJoin(prop);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(TypedProp.Association<?, ?> prop, JoinType joinType) {
        return this.raw().inverseJoin(prop, joinType);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock) {
        return this.raw().inverseJoin(targetTableType, backPropBlock);
    }

    @Override
    public <XT extends Table<?>> XT inverseJoin(Class<XT> targetTableType, Function<XT, ? extends Table<?>> backPropBlock, JoinType joinType) {
        return this.raw().inverseJoin(targetTableType, backPropBlock, joinType);
    }

    @Override
    public Selection<E> fetch(Fetcher<E> fetcher) {
        return this.raw().fetch(fetcher);
    }

    @Override
    public TableEx<E> asTableEx() {
        return this.raw().asTableEx();
    }

    public Table<E> __unwrap() {
        return this.raw();
    }

    public int hashCode() {
        return this.raw().hashCode();
    }

    public boolean equals(Object obj) {
        return this.raw().equals(obj);
    }

    public String toString() {
        return this.raw().toString();
    }

    private Table<E> raw() {
        Table<E> raw = this._raw;
        if (raw == null) {
            throw new IllegalStateException("FluentTable has not been bound");
        }
        return raw;
    }
}

