/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.event.binlog.BinLogModule;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.jetbrains.annotations.NotNull;

public class BinLogParser {
    private final ObjectMapper mapper;

    public BinLogParser(Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap) {
        this(scalarProviderMap, null);
    }

    public BinLogParser(Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, ObjectMapper mapper) {
        if (scalarProviderMap == null) {
            throw new IllegalArgumentException("scalarProviderMap cannot be null");
        }
        ObjectMapper clonedMapper = mapper != null ? new ObjectMapper(mapper){} : new ObjectMapper();
        clonedMapper.registerModule((Module)new BinLogModule(scalarProviderMap));
        this.mapper = clonedMapper;
    }

    public <T> T parseEntity(@NotNull Class<T> type, String json) {
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Illegal json: " + json, ex);
        }
    }

    public <T> T parseEntity(@NotNull Class<T> type, JsonNode data) {
        if (data == null || data.isNull()) {
            return null;
        }
        return this.parseEntity(type, data.toString());
    }

    public <T> T parseEntity(@NotNull ImmutableType type, String json) {
        if (type instanceof AssociationType) {
            throw new IllegalArgumentException("type cannot be AssociationType");
        }
        return this.parseEntity(type.getJavaClass(), json);
    }

    public <T> T parseEntity(@NotNull ImmutableType type, JsonNode data) {
        if (data == null || data.isNull()) {
            return null;
        }
        return this.parseEntity(type, data.toString());
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull AssociationType associationType, JsonNode data) {
        Iterator itr = data.fields();
        Number sourceId = null;
        Number targetId = null;
        while (itr.hasNext()) {
            Object value;
            Map.Entry e = (Map.Entry)itr.next();
            ImmutableProp targetProp = associationType.getPropByColumnName((String)e.getKey());
            JsonNode childNode = (JsonNode)e.getValue();
            Class targetIdType = targetProp.getTargetType().getIdProp().getElementClass();
            if (targetIdType == Byte.TYPE || targetIdType == Byte.class) {
                value = (byte)childNode.asInt();
            } else if (targetIdType == Short.TYPE || targetIdType == Short.class) {
                value = (short)childNode.asInt();
            } else if (targetIdType == Integer.TYPE || targetIdType == Integer.class) {
                value = childNode.asInt();
            } else if (targetIdType == Long.TYPE || targetIdType == Long.class) {
                value = childNode.asLong();
            } else if (targetIdType == String.class) {
                value = childNode.asText();
            } else {
                String content = childNode.toString();
                try {
                    value = this.mapper.readValue(content, targetIdType);
                }
                catch (JsonProcessingException ex) {
                    throw new IllegalArgumentException("Cannot map \"" + content + "\" to target id type of \"" + targetProp + "\"");
                }
            }
            if (targetProp == associationType.getSourceProp()) {
                sourceId = value;
                continue;
            }
            targetId = value;
        }
        if (sourceId == null || targetId == null) {
            throw new IllegalArgumentException("missing some fields of middle table : " + data);
        }
        return new Tuple2<Object, Object>(sourceId, targetId);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull AssociationType associationType, String json) {
        JsonNode data;
        if (json == null || json.isEmpty()) {
            return null;
        }
        try {
            data = this.mapper.readTree(json);
        }
        catch (JsonProcessingException ex) {
            throw new IllegalArgumentException("Illegal json: " + json, ex);
        }
        return this.parseIdPair(associationType, data);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull ImmutableProp prop, JsonNode data) {
        return this.parseIdPair(AssociationType.of(prop), data);
    }

    public <S, T> Tuple2<S, T> parseIdPair(@NotNull ImmutableProp prop, String json) {
        return this.parseIdPair(AssociationType.of(prop), json);
    }
}

