/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.sql.Connection;
import java.util.Objects;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.cache.CacheFilter;
import org.babyfish.jimmer.sql.cache.CacheLoader;
import org.babyfish.jimmer.sql.cache.CacheLoaderWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CacheEnvironment<K, V> {
    private final JSqlClient sqlClient;
    private final Connection connection;
    private final CacheFilter filter;
    private final CacheLoader<K, V> loader;

    public CacheEnvironment(JSqlClient sqlClient, Connection connection, CacheFilter filter, CacheLoader<K, V> loader, boolean requiresNewDraftContext) {
        this.sqlClient = Objects.requireNonNull(sqlClient, "sqlClient cannot be null");
        this.connection = Objects.requireNonNull(connection, "connection cannot be null");
        this.filter = filter;
        this.loader = CacheLoaderWrapper.wrap(Objects.requireNonNull(loader, "loader cannot be null"), requiresNewDraftContext);
    }

    @NotNull
    public JSqlClient getSqlClient() {
        return this.sqlClient;
    }

    @NotNull
    public Connection getConnection() {
        return this.connection;
    }

    @Nullable
    public CacheFilter getFilter() {
        return this.filter;
    }

    @NotNull
    public CacheLoader<K, V> getLoader() {
        return this.loader;
    }

    public int hashCode() {
        return Objects.hash(this.sqlClient, this.connection, this.filter, this.loader);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheEnvironment that = (CacheEnvironment)o;
        return this.sqlClient.equals(that.sqlClient) && this.connection.equals(that.connection) && Objects.equals(this.filter, that.filter) && Objects.equals(this.loader, that.loader);
    }

    public String toString() {
        return "CacheEnvironment{sqlClient=" + this.sqlClient + ", connection=" + this.connection + ", filter=" + this.filter + ", loader=" + this.loader + '}';
    }
}

