/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.TypedId;
import org.babyfish.jimmer.sql.ast.impl.mutation.TypedKey;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;

class MutationCache {
    private final JSqlClient sqlClientWithoutCache;
    private final Map<TypedId, ImmutableSpi> idObjMap = new HashMap<TypedId, ImmutableSpi>();
    private final Map<TypedKey, ImmutableSpi> keyObjMap = new HashMap<TypedKey, ImmutableSpi>();

    public MutationCache(JSqlClient sqlClient) {
        this.sqlClientWithoutCache = sqlClient.caches(CacheDisableConfig::disableAll);
    }

    public ImmutableSpi find(ImmutableSpi example) {
        Object id;
        ImmutableType type = example.__type();
        ImmutableProp idProp = type.getIdProp();
        int idPropId = idProp.getId();
        if (example.__isLoaded(idPropId) && (id = example.__get(idPropId)) != null) {
            return this.idObjMap.get(new TypedId(type, id));
        }
        TypedKey key = TypedKey.of(example, this.keyProps(type), true);
        return this.keyObjMap.get(key);
    }

    public ImmutableSpi findById(ImmutableType type, Object id, Connection con) {
        TypedId typedId = new TypedId(type, id);
        ImmutableSpi spi = this.idObjMap.get(typedId);
        if (spi != null || this.idObjMap.containsKey(typedId)) {
            return spi;
        }
        spi = (ImmutableSpi)this.sqlClientWithoutCache.getEntities().forUpdate().forConnection(con).findById(type.getJavaClass(), id);
        this.idObjMap.put(typedId, spi);
        return spi;
    }

    public Map<Object, ImmutableSpi> findByIds(ImmutableType type, Collection<?> ids, Connection con) {
        if (ids.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<Object, ImmutableSpi> resultMap = new LinkedHashMap<Object, ImmutableSpi>((ids.size() * 4 + 2) / 3);
        for (Object id : ids) {
            TypedId typedId = new TypedId(type, id);
            ImmutableSpi spi = this.idObjMap.get(typedId);
            if (spi == null && !this.idObjMap.containsKey(typedId)) continue;
            resultMap.put(id, spi);
        }
        if (resultMap.size() < ids.size()) {
            ArrayList missedIds = new ArrayList(ids.size() - resultMap.size());
            for (Object id : ids) {
                if (resultMap.containsKey(id)) continue;
                missedIds.add(id);
            }
            if (!missedIds.isEmpty()) {
                Map loadedMap = this.sqlClientWithoutCache.getEntities().findMapByIds(type.getJavaClass(), missedIds);
                for (Object id : missedIds) {
                    ImmutableSpi spi = (ImmutableSpi)loadedMap.get(id);
                    resultMap.put(id, spi);
                    this.idObjMap.put(new TypedId(type, id), spi);
                }
            }
        }
        return resultMap;
    }

    public ImmutableSpi save(ImmutableSpi spi) {
        return this.save(spi, true);
    }

    public ImmutableSpi save(ImmutableSpi spi, boolean merge) {
        TypedKey key;
        ImmutableSpi oldSpi;
        ImmutableType type = spi.__type();
        ImmutableProp idProp = type.getIdProp();
        Set<ImmutableProp> keyProps = this.keyProps(type);
        if (merge && (oldSpi = this.find(spi)) != null) {
            TypedKey oldKey;
            TypedId oldTypedId = new TypedId(type, oldSpi.__get(idProp.getId()));
            this.idObjMap.remove(oldTypedId);
            if (keyProps != null && !keyProps.isEmpty() && (oldKey = TypedKey.of(oldSpi, keyProps, false)) != null) {
                this.keyObjMap.remove(oldKey);
            }
            ImmutableSpi newSpi = spi;
            spi = (ImmutableSpi)Internal.produce((ImmutableType)spi.__type(), (Object)oldSpi, draft -> {
                for (ImmutableProp prop : type.getProps().values()) {
                    int propId = prop.getId();
                    if (!newSpi.__isLoaded(propId)) continue;
                    ((DraftSpi)draft).__set(propId, newSpi.__get(prop.getId()));
                }
            });
        }
        TypedId typedId = new TypedId(type, spi.__get(idProp.getId()));
        this.idObjMap.put(typedId, spi);
        if (keyProps != null && !keyProps.isEmpty() && (key = TypedKey.of(spi, keyProps, false)) != null) {
            this.keyObjMap.put(key, spi);
        }
        return spi;
    }

    protected Set<ImmutableProp> keyProps(ImmutableType type) {
        return Collections.emptySet();
    }
}

