/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.DissociateAction;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.runtime.Converters;

class DeleteCommandImpl
implements DeleteCommand {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableType immutableType;
    private final Collection<?> ids;
    private final Data data;

    public DeleteCommandImpl(JSqlClient sqlClient, Connection con, ImmutableType immutableType, Collection<?> ids) {
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : ids) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        this.sqlClient = sqlClient;
        this.con = con;
        this.immutableType = immutableType;
        this.ids = ids;
        this.data = new Data(sqlClient).freeze();
    }

    public DeleteCommandImpl(DeleteCommandImpl base, Data data) {
        this.sqlClient = base.sqlClient;
        this.con = base.con;
        this.immutableType = base.immutableType;
        this.ids = base.ids;
        this.data = data.freeze();
    }

    @Override
    public DeleteCommand configure(Consumer<DeleteCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (newData.dissociateActionMap.isEmpty()) {
            return this;
        }
        return new DeleteCommandImpl(this, newData);
    }

    @Override
    public DeleteResult execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public DeleteResult execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private DeleteResult executeImpl(Connection con) {
        Deleter deleter = new Deleter(this.data, con);
        deleter.addPreHandleInput(this.immutableType, this.ids);
        return deleter.execute();
    }

    static class Data
    implements DeleteCommand.Cfg {
        private JSqlClient sqlClient;
        private Map<ImmutableProp, DissociateAction> dissociateActionMap;
        private boolean frozen;

        Data(JSqlClient sqlClient) {
            this.sqlClient = sqlClient;
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>();
        }

        Data(JSqlClient sqlClient, Map<ImmutableProp, DissociateAction> dissociateActionMap) {
            this.sqlClient = sqlClient;
            this.dissociateActionMap = dissociateActionMap != null ? new LinkedHashMap<ImmutableProp, DissociateAction>(dissociateActionMap) : new LinkedHashMap<ImmutableProp, DissociateAction>();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.dissociateActionMap = new LinkedHashMap<ImmutableProp, DissociateAction>(base.dissociateActionMap);
        }

        public JSqlClient getSqlClient() {
            return this.sqlClient;
        }

        public DissociateAction getDissociateAction(ImmutableProp prop) {
            DissociateAction action = this.dissociateActionMap.get(prop);
            return action != null ? action : prop.getDissociateAction();
        }

        public Data freeze() {
            if (!this.frozen) {
                this.dissociateActionMap = Collections.unmodifiableMap(this.dissociateActionMap);
                this.frozen = true;
            }
            return this;
        }

        @Override
        public DeleteCommand.Cfg setDissociateAction(ImmutableProp prop, DissociateAction dissociateAction) {
            if (this.frozen) {
                throw new IllegalStateException("The configuration is frozen");
            }
            if (!prop.isReference(TargetLevel.ENTITY) || !(prop.getStorage() instanceof Column)) {
                throw new IllegalArgumentException("'" + prop + "' must be an entity reference property bases on foreign key");
            }
            if (dissociateAction == DissociateAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            this.dissociateActionMap.put(prop, dissociateAction);
            return this;
        }

        @Override
        public DeleteCommand.Cfg setDissociateAction(Class<?> entityType, String prop, DissociateAction dissociateAction) {
            ImmutableType immutableType = ImmutableType.get(entityType);
            ImmutableProp immutableProp = (ImmutableProp)immutableType.getProps().get(prop);
            if (immutableProp == null || !immutableProp.isReference(TargetLevel.ENTITY)) {
                throw new IllegalArgumentException("'" + prop + "' is not entity reference property of \"" + entityType.getName() + "\"");
            }
            return this.setDissociateAction(immutableProp, dissociateAction);
        }

        @Override
        public <T extends Table<?>> DeleteCommand.Cfg setDissociateAction(Class<T> tableType, Function<T, Table<?>> block, DissociateAction dissociateAction) {
            return this.setDissociateAction(ImmutableProps.join(tableType, block), dissociateAction);
        }
    }
}

