/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.jackson.DeserializeUtils;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

class BinLogDeserializer
extends StdDeserializer<Object> {
    private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap;
    private final ImmutableType immutableType;

    public BinLogDeserializer(Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.scalarProviderMap = scalarProviderMap;
        this.immutableType = immutableType;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce((ImmutableType)this.immutableType, null, draft -> {
            Iterator itr = node.fields();
            while (itr.hasNext()) {
                Object value;
                Map.Entry fieldEntry = (Map.Entry)itr.next();
                String columnName = (String)fieldEntry.getKey();
                JsonNode childNode = (JsonNode)fieldEntry.getValue();
                ImmutableProp prop = this.immutableType.getPropByColumnName(columnName);
                if (prop.isAssociation()) {
                    ImmutableProp targetIdProp = prop.getTargetType().getIdProp();
                    Object valueId = DeserializeUtils.readTreeAsValue((DeserializationContext)ctx, (JsonNode)childNode, (JavaType)SimpleType.constructUnsafe((Class)targetIdProp.getElementClass()));
                    value = valueId == null ? null : Internal.produce((ImmutableType)prop.getTargetType(), null, targetDraft -> ((DraftSpi)targetDraft).__set(targetIdProp.getId(), valueId));
                } else {
                    ScalarProvider<?, ?> provider = this.scalarProviderMap.get(prop.getElementClass());
                    Class jsonDataType = provider != null ? provider.getSqlType() : prop.getElementClass();
                    value = DeserializeUtils.readTreeAsValue((DeserializationContext)ctx, (JsonNode)childNode, (JavaType)SimpleType.constructUnsafe((Class)jsonDataType));
                    if (provider != null && value != null) {
                        value = provider.toScalar(value);
                    }
                }
                ((DraftSpi)draft).__set(prop.getId(), value);
            }
        });
    }
}

