/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast;

import java.util.function.Consumer;
import org.babyfish.jimmer.sql.ast.Expression;
import org.babyfish.jimmer.sql.ast.impl.CompositePredicate;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressionContext;
import org.babyfish.jimmer.sql.ast.impl.SqlExpressions;

public interface Predicate
extends Expression<Boolean> {
    public Predicate and(Predicate var1);

    public Predicate or(Predicate var1);

    public Predicate not();

    public static Predicate and(Predicate ... predicates) {
        return CompositePredicate.and(predicates);
    }

    public static Predicate or(Predicate ... predicates) {
        return CompositePredicate.or(predicates);
    }

    public static Predicate not(Predicate predicate) {
        if (predicate == null) {
            return null;
        }
        return predicate.not();
    }

    public static Predicate sql(String sql) {
        return Predicate.sql(sql, null);
    }

    public static Predicate sql(String sql, Consumer<SqlExpressionContext> block) {
        return (Predicate)SqlExpressions.of(Boolean.class, sql, block);
    }
}

