/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.fetcher.impl.Fetchers;
import org.babyfish.jimmer.sql.runtime.ResultMapper;

public class Selectors {
    private Selectors() {
    }

    public static <R> List<R> select(JSqlClient sqlClient, Connection con, String sql, List<Object> variables, List<Selection<?>> selections) {
        return sqlClient.getExecutor().execute(con, sql, variables, null, stmt -> {
            ArrayList<Object> results = new ArrayList<Object>();
            try (ResultSet resultSet = stmt.executeQuery();){
                ResultMapper resultMapper = new ResultMapper(sqlClient, selections, resultSet);
                while (resultSet.next()) {
                    results.add(resultMapper.map());
                }
            }
            Fetchers.fetch(sqlClient, con, selections, results);
            return results;
        });
    }

    public static <R> void forEach(JSqlClient sqlClient, Connection con, String sql, List<Object> variables, List<Selection<?>> selections, int batchSize, Consumer<R> consumer) {
        sqlClient.getExecutor().execute(con, sql, variables, null, stmt -> {
            ArrayList<Object> results = new ArrayList<Object>();
            try (ResultSet resultSet = stmt.executeQuery();){
                ResultMapper resultMapper = new ResultMapper(sqlClient, selections, resultSet);
                while (resultSet.next()) {
                    results.add(resultMapper.map());
                    if (results.size() < batchSize) continue;
                    Fetchers.fetch(sqlClient, con, selections, results);
                    for (Object e : results) {
                        consumer.accept(e);
                    }
                    results.clear();
                }
            }
            Fetchers.fetch(sqlClient, con, selections, results);
            for (Object e : results) {
                consumer.accept(e);
            }
            return null;
        });
    }
}

