/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TargetLevel;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheFactory;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.cache.LocatedCacheImpl;
import org.babyfish.jimmer.sql.event.binlog.BinLogParser;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public class CacheConfig {
    private final Map<ImmutableType, Cache<?, ?>> objectCacheMap = new LinkedHashMap();
    private final Map<ImmutableProp, Cache<?, ?>> propCacheMap = new LinkedHashMap();
    private CacheOperator operator;
    private ObjectMapper binLogObjectMapper;

    public CacheConfig setCacheFactory(Class<?>[] entityTypes, CacheFactory cacheFactory) {
        if (entityTypes.length == 0) {
            throw new IllegalArgumentException("vararg \"entityTypes\" cannot be empty");
        }
        if (cacheFactory == null) {
            throw new IllegalArgumentException("cacheFactory cannot bee null");
        }
        for (Class<?> entityType : entityTypes) {
            Cache<?, ?> objectCache;
            ImmutableType type = ImmutableType.get(entityType);
            if (!this.objectCacheMap.containsKey(type) && (objectCache = cacheFactory.createObjectCache(type)) != null) {
                this.objectCacheMap.put(type, objectCache);
            }
            for (ImmutableProp prop : type.getProps().values()) {
                Cache<?, ?> propCache;
                if (!prop.isAssociation(TargetLevel.ENTITY) && !prop.hasTransientResolver() || this.propCacheMap.containsKey(prop) || (propCache = prop.hasTransientResolver() ? cacheFactory.createResolverCache(prop) : (prop.isReferenceList(TargetLevel.ENTITY) ? cacheFactory.createAssociatedIdListCache(prop) : cacheFactory.createAssociatedIdCache(prop))) == null) continue;
                this.propCacheMap.put(prop, propCache);
            }
        }
        return this;
    }

    public <T> CacheConfig setObjectCache(Class<T> type, Cache<?, T> cache) {
        ImmutableType immutableType = ImmutableType.get(type);
        this.objectCacheMap.put(immutableType, LocatedCacheImpl.unwrap(cache));
        return this;
    }

    public <ST extends Table<?>> CacheConfig setAssociatedIdCache(Class<ST> sourceTableType, Function<ST, Table<?>> targetTableGetter, Cache<?, ?> cache) {
        ImmutableProp prop = ImmutableProps.join(sourceTableType, targetTableGetter);
        return this.setAssociatedIdCache(prop, cache);
    }

    public CacheConfig setAssociatedIdCache(ImmutableProp prop, Cache<?, ?> cache) {
        if (!prop.isReference(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("The prop \"" + prop + "\" is not entity reference");
        }
        this.propCacheMap.put(prop, LocatedCacheImpl.unwrap(cache));
        return this;
    }

    public <T, ST extends Table<?>, TT extends Table<T>> CacheConfig setAssociatedIdListCache(Class<ST> sourceTableType, Function<ST, Table<?>> targetTableGetter, Cache<?, List<?>> cache) {
        ImmutableProp prop = ImmutableProps.join(sourceTableType, targetTableGetter);
        return this.setAssociatedIdListCache(prop, cache);
    }

    public CacheConfig setAssociatedIdListCache(ImmutableProp prop, Cache<?, List<?>> cache) {
        if (!prop.isReferenceList(TargetLevel.ENTITY)) {
            throw new IllegalArgumentException("The prop \"" + prop + "\" is not entity list");
        }
        this.propCacheMap.put(prop, LocatedCacheImpl.unwrap(cache));
        return this;
    }

    public CacheConfig setResolverCache(ImmutableProp prop, Cache<?, ?> cache) {
        if (!prop.hasTransientResolver()) {
            throw new IllegalArgumentException("The prop \"" + prop + "\" is transient property with resolver");
        }
        this.propCacheMap.put(prop, LocatedCacheImpl.unwrap(cache));
        return this;
    }

    public CacheConfig setCacheOperator(CacheOperator operator) {
        this.operator = operator;
        return this;
    }

    public CacheConfig setBinLogObjectMapper(ObjectMapper objectMapper) {
        this.binLogObjectMapper = objectMapper;
        return this;
    }

    Caches build(Triggers triggers, Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap) {
        for (ImmutableProp prop : this.propCacheMap.keySet()) {
            if (!prop.isAssociation(TargetLevel.ENTITY) || this.objectCacheMap.containsKey(prop.getTargetType())) continue;
            throw new IllegalStateException("The cache for association property \"" + prop + "\" is configured but there is no cache for the target type \"" + prop.getTargetType() + "\"");
        }
        return new CachesImpl(triggers, this.objectCacheMap, this.propCacheMap, this.operator, new BinLogParser(scalarProviderMap, this.binLogObjectMapper));
    }
}

