/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.TypedProp;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.DefaultScalarProviders;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.TransientResolverManager;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.impl.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.AssociationsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Mutations;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggersImpl;
import org.babyfish.jimmer.sql.fluent.Fluent;
import org.babyfish.jimmer.sql.fluent.impl.FluentImpl;
import org.babyfish.jimmer.sql.loader.ListLoader;
import org.babyfish.jimmer.sql.loader.ReferenceLoader;
import org.babyfish.jimmer.sql.loader.ValueLoader;
import org.babyfish.jimmer.sql.loader.impl.Loaders;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

class JSqlClientImpl
implements JSqlClient {
    private static final ConnectionManager ILLEGAL_CONNECTION_MANAGER = new ConnectionManager(){

        @Override
        public <R> R execute(Function<Connection, R> block) {
            throw new ExecutionException("ConnectionManager of SqlClient is not configured");
        }
    };
    private final ConnectionManager connectionManager;
    private final ConnectionManager slaveConnectionManager;
    private final Dialect dialect;
    private final Executor executor;
    private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap;
    private final Map<Class<?>, IdGenerator> idGeneratorMap;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final Entities entities;
    private final Caches caches;
    private final Triggers triggers;
    private final TransientResolverManager transientResolverManager;

    private JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, Map<Class<?>, IdGenerator> idGeneratorMap, int defaultBatchSize, int defaultListBatchSize, Entities entities, Caches caches, Triggers triggers, TransientResolverManager transientResolverManager) {
        this.connectionManager = connectionManager != null ? connectionManager : ILLEGAL_CONNECTION_MANAGER;
        this.slaveConnectionManager = slaveConnectionManager;
        this.dialect = dialect != null ? dialect : new DefaultDialect();
        this.executor = executor != null ? executor : DefaultExecutor.INSTANCE;
        this.scalarProviderMap = scalarProviderMap;
        this.idGeneratorMap = idGeneratorMap;
        this.defaultBatchSize = defaultBatchSize;
        this.defaultListBatchSize = defaultListBatchSize;
        this.entities = entities != null ? entities : new EntitiesImpl(this);
        this.caches = caches != null ? caches : CachesImpl.of(triggers, scalarProviderMap, null);
        this.triggers = triggers;
        this.transientResolverManager = transientResolverManager != null ? transientResolverManager : this.createTransientResolverManager();
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionManager getSlaveConnectionManager(boolean forUpdate) {
        ConnectionManager slave = this.slaveConnectionManager;
        if (slave != null && !forUpdate) {
            return slave;
        }
        return this.connectionManager;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> scalarType) {
        ScalarProvider<?, ?> provider = this.scalarProviderMap.get(scalarType);
        return provider != null ? provider : DefaultScalarProviders.getProvider(scalarType);
    }

    @Override
    public IdGenerator getIdGenerator(Class<?> entityType) {
        IdGenerator userIdGenerator = this.idGeneratorMap.get(entityType);
        if (userIdGenerator == null && (userIdGenerator = this.idGeneratorMap.get(null)) == null) {
            userIdGenerator = ImmutableType.get(entityType).getIdGenerator();
        }
        return userIdGenerator;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @Override
    public Fluent createFluent() {
        return new FluentImpl(this);
    }

    @Override
    public <T extends Table<?>, R> ConfigurableRootQuery<T, R> createQuery(Class<T> tableType, BiFunction<MutableRootQuery<T>, T, ConfigurableRootQuery<T, R>> block) {
        return Queries.createQuery((JSqlClient)this, tableType, block);
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>, R> ConfigurableRootQuery<AssociationTable<SE, ST, TE, TT>, R> createAssociationQuery(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter, BiFunction<MutableRootQuery<AssociationTable<SE, ST, TE, TT>>, AssociationTable<SE, ST, TE, TT>, ConfigurableRootQuery<AssociationTable<SE, ST, TE, TT>, R>> block) {
        return Queries.createAssociationQuery(this, sourceTableType, targetTableGetter, block);
    }

    @Override
    public <T extends Table<?>> Executable<Integer> createUpdate(Class<T> tableType, BiConsumer<MutableUpdate, T> block) {
        return Mutations.createUpdate((JSqlClient)this, tableType, block);
    }

    @Override
    public <T extends Table<?>> Executable<Integer> createDelete(Class<T> tableType, BiConsumer<MutableDelete, T> block) {
        return Mutations.createDelete(this, tableType, block);
    }

    @Override
    public Entities getEntities() {
        return this.entities;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    @Override
    public <ST extends Table<?>> Associations getAssociations(Class<ST> sourceTableType, Function<ST, ? extends Table<?>> block) {
        return this.getAssociations(ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public Associations getAssociations(Class<?> entityType, String prop) {
        return this.getAssociations(ImmutableType.get(entityType).getProp(prop));
    }

    @Override
    public Associations getAssociations(ImmutableProp immutableProp) {
        return this.getAssociations(AssociationType.of(immutableProp));
    }

    @Override
    public Associations getAssociations(AssociationType associationType) {
        return new AssociationsImpl(this, null, associationType);
    }

    @Override
    public <S, V> ValueLoader<S, V> getValueLoader(TypedProp.Scalar<S, V> prop) {
        return Loaders.createValueLoader(this, prop.unwrap());
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ReferenceLoader<SE, TE, TT> getReferenceLoader(Class<ST> sourceTableType, Function<ST, TT> block) {
        return Loaders.createReferenceLoader(this, ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ListLoader<SE, TE, TT> getListLoader(Class<ST> sourceTableType, Function<ST, TT> block) {
        return Loaders.createListLoader(this, ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public Caches getCaches() {
        return this.caches;
    }

    @Override
    public JSqlClient caches(Consumer<CacheDisableConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        CacheDisableConfig cfg = new CacheDisableConfig();
        block.accept(cfg);
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, new CachesImpl((CachesImpl)this.caches, cfg), this.triggers, this.transientResolverManager);
    }

    @Override
    public JSqlClient disableSlaveConnectionManager() {
        if (this.slaveConnectionManager == null) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, null, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.caches, this.triggers, this.transientResolverManager);
    }

    @Override
    public TransientResolver<?, ?> getResolver(ImmutableProp prop) {
        return this.transientResolverManager.get(prop);
    }

    private TransientResolverManager createTransientResolverManager() {
        TransientResolverManager manager = new TransientResolverManager(this);
        if (this.caches != null) {
            for (ImmutableType type : ((CachesImpl)this.caches).getObjectCacheMap().keySet()) {
                for (ImmutableProp prop : type.getProps().values()) {
                    if (!prop.hasTransientResolver()) continue;
                    manager.get(prop);
                }
            }
            for (ImmutableProp prop : ((CachesImpl)this.caches).getPropCacheMap().keySet()) {
                if (!prop.hasTransientResolver()) continue;
                manager.get(prop);
            }
        }
        return manager;
    }

    public static class BuilderImpl
    implements JSqlClient.Builder {
        private ConnectionManager connectionManager;
        private ConnectionManager slaveConnectionManager;
        private Dialect dialect;
        private Executor executor;
        private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap = new HashMap();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private Caches caches;
        private final Triggers triggers = new TriggersImpl();

        @Override
        public JSqlClient.Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setSlaveConnectionManager(ConnectionManager connectionManager) {
            this.slaveConnectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        @Override
        public JSqlClient.Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            if (this.scalarProviderMap.containsKey(scalarProvider.getScalarType())) {
                throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarProvider.getScalarType() + "\" twice");
            }
            this.scalarProviderMap.put(scalarProvider.getScalarType(), scalarProvider);
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setCaches(Consumer<CacheConfig> block) {
            this.caches = CachesImpl.of(this.triggers, this.scalarProviderMap, block);
            return this;
        }

        @Override
        public JSqlClient build() {
            return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, null, this.caches, this.triggers, null);
        }
    }
}

