/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.event.AssociationListener;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.event.EntityListener;
import org.babyfish.jimmer.sql.event.ForeignKeyAssociationListenerProxy;
import org.babyfish.jimmer.sql.event.MiddleTableAssociationListenerProxy;
import org.babyfish.jimmer.sql.event.MiddleTableListener;
import org.babyfish.jimmer.sql.event.Utils;
import org.babyfish.jimmer.sql.meta.MiddleTable;

public class TriggersImpl
implements Triggers {
    private final ConcurrentMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>> entityTableListenerMultiMap = new ConcurrentHashMap<ImmutableType, CopyOnWriteArrayList<EntityListener<ImmutableSpi>>>();
    private final ConcurrentMap<ImmutableProp, CopyOnWriteArrayList<MiddleTableListener>> middleTableListenerMultiMap = new ConcurrentHashMap<ImmutableProp, CopyOnWriteArrayList<MiddleTableListener>>();

    @Override
    public void addEntityListener(ImmutableType immutableType, EntityListener<ImmutableSpi> listener) {
        this.entityTableListenerMultiMap.computeIfAbsent(immutableType, it -> new CopyOnWriteArrayList()).add(listener);
    }

    @Override
    public void removeEntityListener(ImmutableType immutableType, EntityListener<ImmutableSpi> listener) {
        this.entityTableListenerMultiMap.computeIfAbsent(immutableType, it -> new CopyOnWriteArrayList()).remove(listener);
    }

    @Override
    public void addAssociationListener(ImmutableProp prop, AssociationListener listener) {
        ImmutableProp primaryAssociationProp = Utils.primaryAssociationProp(prop);
        if (primaryAssociationProp.getStorage() instanceof MiddleTable) {
            this.addMiddleTableListener(primaryAssociationProp, new MiddleTableAssociationListenerProxy(prop, listener));
        } else {
            this.addEntityListener(primaryAssociationProp.getDeclaringType(), new ForeignKeyAssociationListenerProxy(prop, listener));
        }
    }

    @Override
    public void removeAssociationListener(ImmutableProp prop, AssociationListener listener) {
        ImmutableProp primaryAssociationProp = Utils.primaryAssociationProp(prop);
        if (primaryAssociationProp.getStorage() instanceof MiddleTable) {
            this.removeMiddleTableListener(primaryAssociationProp, new MiddleTableAssociationListenerProxy(prop, listener));
        } else {
            this.removeEntityListener(primaryAssociationProp.getDeclaringType(), new ForeignKeyAssociationListenerProxy(prop, listener));
        }
    }

    public boolean hasListeners(ImmutableType type) {
        List listeners = (List)this.entityTableListenerMultiMap.get(type);
        return listeners != null && !listeners.isEmpty();
    }

    public boolean hasListeners(ImmutableProp prop) {
        ImmutableProp primaryAssociationProp = Utils.primaryAssociationProp(prop);
        if (primaryAssociationProp.getStorage() instanceof MiddleTable) {
            List listeners = (List)this.middleTableListenerMultiMap.get(primaryAssociationProp);
            return listeners != null && !listeners.isEmpty();
        }
        List listeners = (List)this.entityTableListenerMultiMap.get(primaryAssociationProp.getDeclaringType());
        return listeners != null && !listeners.isEmpty();
    }

    private void addMiddleTableListener(ImmutableProp primaryAssociationProp, MiddleTableListener listener) {
        this.middleTableListenerMultiMap.computeIfAbsent(primaryAssociationProp, it -> new CopyOnWriteArrayList()).add(listener);
    }

    private void removeMiddleTableListener(ImmutableProp primaryAssociationProp, MiddleTableListener listener) {
        this.middleTableListenerMultiMap.computeIfAbsent(primaryAssociationProp, it -> new CopyOnWriteArrayList()).remove(listener);
    }

    @Override
    public void fireEntityTableChange(Object oldRow, Object newRow) {
        if (oldRow == null && newRow == null) {
            return;
        }
        if (oldRow != null && !(oldRow instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("oldRow must be immutable");
        }
        if (newRow != null && !(newRow instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("newRow must be immutable");
        }
        EntityEvent<ImmutableSpi> event = new EntityEvent<ImmutableSpi>((ImmutableSpi)oldRow, (ImmutableSpi)newRow);
        List listeners = (List)this.entityTableListenerMultiMap.get(event.getImmutableType());
        if (listeners != null && !listeners.isEmpty()) {
            Throwable throwable = null;
            for (EntityListener listener : listeners) {
                try {
                    listener.onChange(event);
                }
                catch (Error | RuntimeException ex) {
                    if (throwable != null) continue;
                    throwable = ex;
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }

    @Override
    public void fireMiddleTableDelete(ImmutableProp prop, Object sourceId, Object targetId) {
        ImmutableProp primaryAssociationProp = Utils.primaryAssociationProp(prop);
        List listeners = (List)this.middleTableListenerMultiMap.get(primaryAssociationProp);
        if (listeners != null && !listeners.isEmpty()) {
            Throwable throwable = null;
            if (prop == primaryAssociationProp) {
                for (MiddleTableListener listener : listeners) {
                    try {
                        listener.delete(sourceId, targetId);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            } else {
                for (MiddleTableListener listener : listeners) {
                    try {
                        listener.delete(targetId, sourceId);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }

    @Override
    public void fireMiddleTableInsert(ImmutableProp prop, Object sourceId, Object targetId) {
        ImmutableProp primaryAssociationProp = Utils.primaryAssociationProp(prop);
        List listeners = (List)this.middleTableListenerMultiMap.get(primaryAssociationProp);
        if (listeners != null && !listeners.isEmpty()) {
            Throwable throwable = null;
            if (prop == primaryAssociationProp) {
                for (MiddleTableListener listener : listeners) {
                    try {
                        listener.insert(sourceId, targetId);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            } else {
                for (MiddleTableListener listener : listeners) {
                    try {
                        listener.insert(targetId, sourceId);
                    }
                    catch (Error | RuntimeException ex) {
                        if (throwable != null) continue;
                        throwable = ex;
                    }
                }
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            if (throwable != null) {
                throw (Error)throwable;
            }
        }
    }
}

