/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.event.EventType;

public class EntityEvent<E> {
    private E oldEntity;
    private E newEntity;

    public EntityEvent(E oldEntity, E newEntity) {
        if (oldEntity == null && newEntity == null) {
            throw new IllegalArgumentException("Both oldEntity and newEntity are null");
        }
        if (oldEntity != null && !(oldEntity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("oldEntity is not immutable object");
        }
        if (newEntity != null && !(newEntity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("newEntity is not immutable object");
        }
        if (oldEntity != null && newEntity != null) {
            ImmutableSpi oe = (ImmutableSpi)oldEntity;
            ImmutableSpi ne = (ImmutableSpi)newEntity;
            if (oe.__type() != ne.__type()) {
                throw new IllegalArgumentException("oldEntity and newEntity must belong to same type");
            }
            int idPropId = oe.__type().getIdProp().getId();
            if (!oe.__get(idPropId).equals(ne.__get(idPropId))) {
                throw new IllegalArgumentException("oldEntity and newEntity must have same id");
            }
        }
        this.oldEntity = oldEntity;
        this.newEntity = newEntity;
    }

    public E getOldEntity() {
        return this.oldEntity;
    }

    public E getNewEntity() {
        return this.newEntity;
    }

    public Object getId() {
        E oe = this.oldEntity;
        int idPropId = this.getImmutableType().getIdProp().getId();
        if (oe != null) {
            return ((ImmutableSpi)oe).__get(idPropId);
        }
        return ((ImmutableSpi)this.newEntity).__get(idPropId);
    }

    public ImmutableType getImmutableType() {
        E oe = this.oldEntity;
        if (oe != null) {
            return ((ImmutableSpi)oe).__type();
        }
        return ((ImmutableSpi)this.newEntity).__type();
    }

    public EventType getEventType() {
        if (this.oldEntity == null) {
            return EventType.INSERT;
        }
        if (this.newEntity == null) {
            return EventType.DELETE;
        }
        return EventType.UPDATE;
    }

    public int hashCode() {
        return Objects.hash(this.oldEntity, this.newEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityEvent event = (EntityEvent)o;
        return Objects.equals(this.oldEntity, event.oldEntity) && Objects.equals(this.newEntity, event.newEntity);
    }

    public String toString() {
        return "Event{oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + '}';
    }
}

