/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.event.EventType;

public class AssociationEvent {
    private ImmutableProp prop;
    private Object sourceId;
    private Object detachedTargetId;
    private Object attachedTargetId;

    public AssociationEvent(ImmutableProp prop, Object sourceId, Object detachedTargetId, Object attachedTargetId) {
        if (prop == null) {
            throw new IllegalArgumentException("prop cannot be null");
        }
        if (!prop.isAssociation()) {
            throw new IllegalArgumentException("prop must be association");
        }
        if (sourceId == null || sourceId.getClass() != prop.getDeclaringType().getIdProp().getElementClass()) {
            throw new IllegalArgumentException("The type of sourceId \"" + sourceId + "\" does not match \"" + prop.getDeclaringType().getIdProp() + "\"");
        }
        Class targetIdClass = prop.getTargetType().getIdProp().getElementClass();
        if (detachedTargetId != null && detachedTargetId.getClass() != targetIdClass) {
            throw new IllegalArgumentException("The type of detachedTargetId \"" + sourceId + "\" does not match \"" + prop.getTargetType().getIdProp() + "\"");
        }
        if (attachedTargetId != null && attachedTargetId.getClass() != targetIdClass) {
            throw new IllegalArgumentException("The type of attachedTargetId \"" + sourceId + "\" does not match \"" + prop.getTargetType().getIdProp() + "\"");
        }
        this.prop = prop;
        this.sourceId = sourceId;
        this.detachedTargetId = detachedTargetId;
        this.attachedTargetId = attachedTargetId;
    }

    public ImmutableProp getImmutableProp() {
        return this.prop;
    }

    public Object getSourceId() {
        return this.sourceId;
    }

    public Object getDetachedTargetId() {
        return this.detachedTargetId;
    }

    public Object getAttachedTargetId() {
        return this.attachedTargetId;
    }

    public EventType getEventType() {
        if (this.detachedTargetId == null) {
            return EventType.INSERT;
        }
        if (this.attachedTargetId == null) {
            return EventType.DELETE;
        }
        return EventType.UPDATE;
    }

    public int hashCode() {
        return Objects.hash(this.prop, this.sourceId, this.detachedTargetId, this.attachedTargetId);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AssociationEvent that = (AssociationEvent)o;
        return this.prop.equals(that.prop) && this.sourceId.equals(that.sourceId) && Objects.equals(this.detachedTargetId, that.detachedTargetId) && Objects.equals(this.attachedTargetId, that.attachedTargetId);
    }

    public String toString() {
        return "AssociationEvent{prop=" + this.prop + ", sourceId=" + this.sourceId + ", detachedTargetId=" + this.detachedTargetId + ", attachedTargetId=" + this.attachedTargetId + '}';
    }
}

