/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.cache.LocatedCacheImpl;

public class CachesImpl
implements Caches {
    private final Map<ImmutableType, LocatedCacheImpl<?, ?>> objectCacheMap;
    private final Map<ImmutableProp, LocatedCacheImpl<?, ?>> associationCacheMap;
    private final CacheOperator operator;
    private final boolean disableAll;
    private final Set<ImmutableType> disabledTypes;
    private final Set<ImmutableProp> disabledProps;

    public CachesImpl(Triggers triggers, Map<ImmutableType, Cache<?, ?>> objectCacheMap, Map<ImmutableProp, Cache<?, ?>> associationCacheMap, CacheOperator operator) {
        LinkedHashMap objectCacheWrapperMap = new LinkedHashMap();
        for (Map.Entry<ImmutableType, Cache<?, ?>> e : objectCacheMap.entrySet()) {
            ImmutableType type = e.getKey();
            objectCacheWrapperMap.put(type, this.wrapObjectCache(triggers, e.getValue(), type));
        }
        LinkedHashMap associationCacheWrapperMap = new LinkedHashMap();
        for (Map.Entry<ImmutableProp, Cache<?, ?>> e : associationCacheMap.entrySet()) {
            ImmutableProp prop = e.getKey();
            associationCacheWrapperMap.put(prop, this.wrapAssociationCache(triggers, e.getValue(), prop));
        }
        this.objectCacheMap = objectCacheWrapperMap;
        this.associationCacheMap = associationCacheWrapperMap;
        this.operator = operator;
        this.disableAll = false;
        this.disabledTypes = Collections.emptySet();
        this.disabledProps = Collections.emptySet();
    }

    public CachesImpl(CachesImpl base, CacheDisableConfig cfg) {
        this.objectCacheMap = base.objectCacheMap;
        this.associationCacheMap = base.associationCacheMap;
        this.operator = base.operator;
        this.disableAll = cfg.isDisableAll();
        this.disabledTypes = cfg.getDisabledTypes();
        this.disabledProps = cfg.getDisabledProps();
    }

    public <K, V> LocatedCache<K, V> getObjectCache(ImmutableType type) {
        if (this.disableAll || this.disabledTypes.contains(type)) {
            return null;
        }
        return LocatedCacheImpl.export(this.objectCacheMap.get(type));
    }

    public <K, V> LocatedCache<K, V> getAssociationCache(ImmutableProp prop) {
        if (this.disableAll || this.disabledProps.contains(prop) || this.disabledTypes.contains(prop.getTargetType())) {
            return null;
        }
        return LocatedCacheImpl.export(this.associationCacheMap.get(prop));
    }

    private LocatedCacheImpl<?, ?> wrapObjectCache(Triggers triggers, Cache<?, ?> cache, ImmutableType type) {
        if (cache == null) {
            return null;
        }
        LocatedCacheImpl<?, ?> wrapper = LocatedCacheImpl.wrap(cache, type);
        triggers.addEntityListener(type, e -> {
            ImmutableSpi oldEntity = (ImmutableSpi)e.getOldEntity();
            if (oldEntity != null) {
                Object id = oldEntity.__get(type.getIdProp().getId());
                if (this.operator != null) {
                    this.operator.delete(wrapper, id);
                } else {
                    wrapper.delete(id);
                }
            }
        });
        return wrapper;
    }

    private LocatedCacheImpl<?, ?> wrapAssociationCache(Triggers triggers, Cache<?, ?> cache, ImmutableProp prop) {
        if (cache == null) {
            return null;
        }
        LocatedCacheImpl<?, ?> wrapper = LocatedCacheImpl.wrap(cache, prop);
        triggers.addAssociationListener(prop, e -> {
            Object id = e.getSourceId();
            if (this.operator != null) {
                this.operator.delete(wrapper, id);
            } else {
                wrapper.delete(id);
            }
        });
        return wrapper;
    }
}

