/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheConfig;

public interface Caches {
    default public <K, V> Cache<K, V> getObjectCache(Class<V> type) {
        return this.getObjectCache(ImmutableType.get(type));
    }

    public <K, V> Cache<K, V> getObjectCache(ImmutableType var1);

    default public <K, V, ST extends Table<?>> Cache<K, V> getAssociationCache(Class<ST> sourceTableType, Function<ST, ? extends Table<?>> targetTableGetter) {
        return this.getAssociationCache(ImmutableProps.join(sourceTableType, targetTableGetter));
    }

    public <K, V> Cache<K, V> getAssociationCache(ImmutableProp var1);

    public static Caches of(Triggers triggers, Consumer<CacheConfig> block) {
        CacheConfig cfg = new CacheConfig();
        if (block != null) {
            block.accept(cfg);
        }
        return cfg.build(triggers);
    }
}

