/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.AbstractEntitySaveCommandImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Saver;
import org.babyfish.jimmer.sql.ast.impl.mutation.SaverCache;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.AffectedTable;
import org.babyfish.jimmer.sql.ast.mutation.BatchEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.BatchSaveResult;

class BatchEntitySaveCommandImpl<E>
extends AbstractEntitySaveCommandImpl
implements BatchEntitySaveCommand<E> {
    private Collection<E> entities;

    BatchEntitySaveCommandImpl(JSqlClient sqlClient, Connection con, Collection<E> entities) {
        super(sqlClient, con, null);
        for (E entity : entities) {
            if (entity instanceof ImmutableSpi) continue;
            throw new IllegalArgumentException("All the elements of entities must be an immutable object");
        }
        this.entities = entities;
    }

    private BatchEntitySaveCommandImpl(BatchEntitySaveCommandImpl<E> base, AbstractEntitySaveCommandImpl.Data data) {
        super(base.sqlClient, base.con, data);
        this.entities = base.entities;
    }

    @Override
    public BatchEntitySaveCommand<E> configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        return (BatchEntitySaveCommand)super.configure(block);
    }

    @Override
    public BatchSaveResult<E> execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public BatchSaveResult<E> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private BatchSaveResult<E> executeImpl(Connection con) {
        SaverCache cache = new SaverCache(this.data);
        LinkedHashMap<AffectedTable, Integer> affectedRowCountMap = new LinkedHashMap<AffectedTable, Integer>();
        List simpleSaveResults = this.entities.stream().map(it -> new Saver(this.data, con, cache, affectedRowCountMap).save(it)).collect(Collectors.toList());
        return new BatchSaveResult(affectedRowCountMap, simpleSaveResults);
    }

    @Override
    BatchEntitySaveCommand<E> create(AbstractEntitySaveCommandImpl.Data data) {
        return new BatchEntitySaveCommandImpl<E>(this, data);
    }
}

