/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.association.loader;

import java.sql.Connection;
import java.util.Collection;
import java.util.Map;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.association.loader.DataLoader;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.fetcher.Filter;

class BatchCommand<S, T>
implements Executable<Map<S, T>> {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableProp prop;
    private final Filter<Table<ImmutableSpi>> filter;
    private final Collection<ImmutableSpi> sources;

    public BatchCommand(JSqlClient sqlClient, Connection con, ImmutableProp prop, Filter<Table<ImmutableSpi>> filter, Collection<ImmutableSpi> sources) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.prop = prop;
        this.filter = filter;
        this.sources = sources;
    }

    @Override
    public Map<S, T> execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public Map<S, T> execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private Map<S, T> executeImpl(Connection con) {
        return new DataLoader(this.sqlClient, con, this.prop, this.filter).load(this.sources);
    }
}

