/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.sql.event.AssociationEvent;
import org.babyfish.jimmer.sql.event.AssociationListener;
import org.babyfish.jimmer.sql.event.MiddleTableListener;

class MiddleTableAssociationListenerProxy
implements MiddleTableListener {
    private final ImmutableProp prop;
    private final AssociationListener listener;

    MiddleTableAssociationListenerProxy(ImmutableProp prop, AssociationListener listener) {
        this.prop = prop;
        this.listener = listener;
    }

    @Override
    public void delete(Object sourceId, Object targetId, Object reason) {
        if (this.prop.getMappedBy() != null) {
            this.listener.onChange(new AssociationEvent(this.prop, targetId, sourceId, null, reason));
        } else {
            this.listener.onChange(new AssociationEvent(this.prop, sourceId, targetId, null, reason));
        }
    }

    @Override
    public void insert(Object sourceId, Object targetId, Object reason) {
        if (this.prop.getMappedBy() != null) {
            this.listener.onChange(new AssociationEvent(this.prop, targetId, null, sourceId, reason));
        } else {
            this.listener.onChange(new AssociationEvent(this.prop, sourceId, null, targetId, reason));
        }
    }

    public int hashCode() {
        return Objects.hash(this.prop, this.listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MiddleTableAssociationListenerProxy that = (MiddleTableAssociationListenerProxy)o;
        return this.prop.equals(that.prop) && this.listener.equals(that.listener);
    }

    public String toString() {
        return "MiddleTableAssociationProxy{prop=" + this.prop + ", listener=" + this.listener + '}';
    }
}

