/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.ModelException;
import org.babyfish.jimmer.sql.Associations;
import org.babyfish.jimmer.sql.Entities;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.Transient;
import org.babyfish.jimmer.sql.TransientResolver;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.Executable;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.impl.mutation.AssociationsImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.EntitiesImpl;
import org.babyfish.jimmer.sql.ast.impl.mutation.Mutations;
import org.babyfish.jimmer.sql.ast.impl.query.Queries;
import org.babyfish.jimmer.sql.ast.mutation.MutableDelete;
import org.babyfish.jimmer.sql.ast.mutation.MutableUpdate;
import org.babyfish.jimmer.sql.ast.query.ConfigurableRootQuery;
import org.babyfish.jimmer.sql.ast.query.MutableRootQuery;
import org.babyfish.jimmer.sql.ast.table.AssociationTable;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.CachesImpl;
import org.babyfish.jimmer.sql.dialect.DefaultDialect;
import org.babyfish.jimmer.sql.dialect.Dialect;
import org.babyfish.jimmer.sql.event.TriggersImpl;
import org.babyfish.jimmer.sql.loader.ListLoader;
import org.babyfish.jimmer.sql.loader.ReferenceLoader;
import org.babyfish.jimmer.sql.loader.ValueLoader;
import org.babyfish.jimmer.sql.loader.impl.Loaders;
import org.babyfish.jimmer.sql.meta.IdGenerator;
import org.babyfish.jimmer.sql.runtime.ConnectionManager;
import org.babyfish.jimmer.sql.runtime.DefaultExecutor;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.Executor;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;
import org.babyfish.jimmer.util.Classes;
import org.babyfish.jimmer.util.StaticCache;

class JSqlClientImpl
implements JSqlClient {
    private static final ConnectionManager ILLEGAL_CONNECTION_MANAGER = new ConnectionManager(){

        @Override
        public <R> R execute(Function<Connection, R> block) {
            throw new ExecutionException("ConnectionManager of SqlClient is not configured");
        }
    };
    private static final Class<?> K_SQL_CLIENT_CLASS;
    private static final Constructor<?> K_SQL_CLIENT_IMPL_CONSTRUCTOR;
    private final ConnectionManager connectionManager;
    private final ConnectionManager slaveConnectionManager;
    private final Dialect dialect;
    private final Executor executor;
    private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap;
    private final Map<Class<?>, IdGenerator> idGeneratorMap;
    private final int defaultBatchSize;
    private final int defaultListBatchSize;
    private final Entities entities;
    private final Triggers triggers;
    private final Caches caches;
    private final StaticCache<ImmutableProp, TransientResolver<?, ?>> resolverCache = new StaticCache(this::createResolver, true);

    public JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, Map<Class<?>, IdGenerator> idGeneratorMap, int defaultBatchSize, int defaultListBatchSize, Caches caches, Triggers triggers) {
        this(connectionManager != null ? connectionManager : ILLEGAL_CONNECTION_MANAGER, slaveConnectionManager, dialect != null ? dialect : DefaultDialect.INSTANCE, executor != null ? executor : DefaultExecutor.INSTANCE, new HashMap(scalarProviderMap), new HashMap(idGeneratorMap), defaultBatchSize, defaultListBatchSize, null, caches, triggers);
    }

    private JSqlClientImpl(ConnectionManager connectionManager, ConnectionManager slaveConnectionManager, Dialect dialect, Executor executor, Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap, Map<Class<?>, IdGenerator> idGeneratorMap, int defaultBatchSize, int defaultListBatchSize, Entities entities, Caches caches, Triggers triggers) {
        this.connectionManager = connectionManager;
        this.slaveConnectionManager = slaveConnectionManager;
        this.dialect = dialect;
        this.executor = executor;
        this.scalarProviderMap = scalarProviderMap;
        this.idGeneratorMap = idGeneratorMap;
        this.defaultBatchSize = defaultBatchSize;
        this.defaultListBatchSize = defaultListBatchSize;
        this.entities = entities != null ? entities : new EntitiesImpl(this);
        this.caches = caches != null ? caches : CachesImpl.of(triggers, null);
        this.triggers = triggers;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public ConnectionManager getSlaveConnectionManager() {
        ConnectionManager slave = this.slaveConnectionManager;
        if (slave != null) {
            return slave;
        }
        return this.connectionManager;
    }

    @Override
    public Dialect getDialect() {
        return this.dialect;
    }

    @Override
    public Executor getExecutor() {
        return this.executor;
    }

    @Override
    public <T, S> ScalarProvider<T, S> getScalarProvider(Class<T> scalarType) {
        return this.scalarProviderMap.get(scalarType);
    }

    @Override
    public IdGenerator getIdGenerator(Class<?> entityType) {
        IdGenerator userIdGenerator = this.idGeneratorMap.get(entityType);
        if (userIdGenerator == null && (userIdGenerator = this.idGeneratorMap.get(null)) == null) {
            userIdGenerator = ImmutableType.get(entityType).getIdGenerator();
        }
        return userIdGenerator;
    }

    @Override
    public int getDefaultBatchSize() {
        return this.defaultBatchSize;
    }

    @Override
    public int getDefaultListBatchSize() {
        return this.defaultListBatchSize;
    }

    @Override
    public <T extends Table<?>, R> ConfigurableRootQuery<T, R> createQuery(Class<T> tableType, BiFunction<MutableRootQuery<T>, T, ConfigurableRootQuery<T, R>> block) {
        return Queries.createQuery((JSqlClient)this, tableType, block);
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>, R> ConfigurableRootQuery<AssociationTable<SE, ST, TE, TT>, R> createAssociationQuery(Class<ST> sourceTableType, Function<ST, TT> targetTableGetter, BiFunction<MutableRootQuery<AssociationTable<SE, ST, TE, TT>>, AssociationTable<SE, ST, TE, TT>, ConfigurableRootQuery<AssociationTable<SE, ST, TE, TT>, R>> block) {
        return Queries.createAssociationQuery(this, sourceTableType, targetTableGetter, block);
    }

    @Override
    public <T extends Table<?>> Executable<Integer> createUpdate(Class<T> tableType, BiConsumer<MutableUpdate, T> block) {
        return Mutations.createUpdate((JSqlClient)this, tableType, block);
    }

    @Override
    public <T extends Table<?>> Executable<Integer> createDelete(Class<T> tableType, BiConsumer<MutableDelete, T> block) {
        return Mutations.createDelete(this, tableType, block);
    }

    @Override
    public Entities getEntities() {
        return this.entities;
    }

    @Override
    public Triggers getTriggers() {
        return this.triggers;
    }

    @Override
    public <ST extends Table<?>> Associations getAssociations(Class<ST> sourceTableType, Function<ST, ? extends Table<?>> block) {
        return this.getAssociations(ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public Associations getAssociations(Class<?> entityType, String prop) {
        return this.getAssociations(ImmutableType.get(entityType).getProp(prop));
    }

    @Override
    public Associations getAssociations(ImmutableProp immutableProp) {
        return this.getAssociations(AssociationType.of(immutableProp));
    }

    @Override
    public Associations getAssociations(AssociationType associationType) {
        return new AssociationsImpl(this, null, associationType);
    }

    @Override
    public <SE, ST extends Table<SE>, V> ValueLoader<SE, V> getValueLoader(Class<ST> sourceTableType, Function<ST, PropExpression<V>> block) {
        return Loaders.createValueLoader(this, ImmutableProps.get(sourceTableType, block));
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ReferenceLoader<SE, TE, TT> getReferenceLoader(Class<ST> sourceTableType, Function<ST, TT> block) {
        return Loaders.createReferenceLoader(this, ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public <SE, ST extends Table<SE>, TE, TT extends Table<TE>> ListLoader<SE, TE, TT> getListLoader(Class<ST> sourceTableType, Function<ST, TT> block) {
        return Loaders.createListLoader(this, ImmutableProps.join(sourceTableType, block));
    }

    @Override
    public Caches getCaches() {
        return this.caches;
    }

    @Override
    public JSqlClient caches(Consumer<CacheDisableConfig> block) {
        if (block == null) {
            throw new IllegalArgumentException("block cannot be null");
        }
        CacheDisableConfig cfg = new CacheDisableConfig();
        block.accept(cfg);
        return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, new CachesImpl((CachesImpl)this.caches, cfg), this.triggers);
    }

    @Override
    public JSqlClient disableSlaveConnectionManager() {
        if (this.slaveConnectionManager == null) {
            return this;
        }
        return new JSqlClientImpl(this.connectionManager, null, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.entities, this.caches, this.triggers);
    }

    @Override
    public TransientResolver<?, ?> getResolver(ImmutableProp prop) {
        return (TransientResolver)this.resolverCache.get((Object)prop);
    }

    private TransientResolver<?, ?> createResolver(ImmutableProp prop) {
        Transient trans = (Transient)prop.getAnnotation(Transient.class);
        if (trans == null) {
            return null;
        }
        Class resolverType = trans.value();
        if (resolverType == Void.TYPE) {
            return null;
        }
        if (!TransientResolver.class.isAssignableFrom(trans.value())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type must implement \"" + TransientResolver.class + "\"");
        }
        if (resolverType.isInterface() || (resolverType.getModifiers() & 0x400) != 0) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type must be non-abstract class");
        }
        if (resolverType.getTypeParameters().length != 0) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the resolver type cannot has parameters");
        }
        Map typeMap = TypeUtils.getTypeArguments((Type)resolverType, TransientResolver.class);
        Type keyType = (Type)typeMap.get(TransientResolver.class.getTypeParameters()[0]);
        Type valueType = (Type)typeMap.get(TransientResolver.class.getTypeParameters()[1]);
        if (!(keyType instanceof Class) || !Classes.matches((Class)((Class)keyType), (Class)prop.getDeclaringType().getIdProp().getElementClass())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the first generic type argument of resolver type must be \"" + prop.getDeclaringType().getIdProp().getElementClass() + "\"");
        }
        if (!(valueType instanceof Class) || !Classes.matches((Class)((Class)valueType), (Class)prop.getElementClass())) {
            throw new ModelException("Illegal property \"" + prop.getName() + "\", the second generic type argument of resolver type must be \"" + prop.getElementClass() + "\"");
        }
        Constructor constructor = null;
        try {
            constructor = resolverType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                return (TransientResolver)constructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw JSqlClientImpl.convertResolverConstructorError(prop, ex);
            }
        }
        try {
            constructor = resolverType.getConstructor(JSqlClient.class);
        }
        catch (NoSuchMethodException ex) {
            // empty catch block
        }
        if (constructor != null) {
            try {
                return (TransientResolver)constructor.newInstance(this);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                throw JSqlClientImpl.convertResolverConstructorError(prop, ex);
            }
        }
        if (K_SQL_CLIENT_CLASS != null) {
            try {
                constructor = resolverType.getConstructor(K_SQL_CLIENT_CLASS);
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            if (constructor != null) {
                Object kSqlClient;
                try {
                    kSqlClient = K_SQL_CLIENT_IMPL_CONSTRUCTOR.newInstance(this);
                }
                catch (InvocationTargetException ex) {
                    throw new AssertionError("Internal bug", ex.getTargetException());
                }
                catch (IllegalAccessException | InstantiationException ex) {
                    throw new AssertionError("Internal bug", ex);
                }
                try {
                    return (TransientResolver)constructor.newInstance(kSqlClient);
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    throw JSqlClientImpl.convertResolverConstructorError(prop, ex);
                }
            }
        }
        throw new ModelException("The resolve type \"" + resolverType.getName() + "\" for the association \"" + prop + "\" does not have no-argument constructor or constructor that accepts SqlClient");
    }

    private static RuntimeException convertResolverConstructorError(ImmutableProp prop, Throwable throwable) {
        if (throwable instanceof InvocationTargetException) {
            throwable = ((InvocationTargetException)throwable).getTargetException();
        }
        return new ModelException("Cannot create resolver \"" + ((Transient)prop.getAnnotation(Transient.class)).value() + "\" for property \"" + prop + "\"", throwable);
    }

    static {
        Class<?> kSqlClientClass = null;
        Class<?> kSqlClientImplClass = null;
        Constructor<?> kSqlClientImplConstructor = null;
        try {
            kSqlClientClass = Class.forName("org.babyfish.jimmer.sql.kt.KSqlClient");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (kSqlClientClass != null) {
            try {
                kSqlClientImplClass = Class.forName("org.babyfish.jimmer.sql.kt.impl.KSqlClientImpl");
                kSqlClientImplConstructor = kSqlClientImplClass.getConstructor(JSqlClient.class);
            }
            catch (ClassNotFoundException | NoSuchMethodException ex) {
                throw new AssertionError("Internal bug", ex);
            }
        }
        K_SQL_CLIENT_CLASS = kSqlClientClass;
        K_SQL_CLIENT_IMPL_CONSTRUCTOR = kSqlClientImplConstructor;
    }

    public static class BuilderImpl
    implements JSqlClient.Builder {
        private ConnectionManager connectionManager;
        private ConnectionManager slaveConnectionManager;
        private Dialect dialect;
        private Executor executor;
        private final Map<Class<?>, ScalarProvider<?, ?>> scalarProviderMap = new HashMap();
        private final Map<Class<?>, IdGenerator> idGeneratorMap = new HashMap();
        private int defaultBatchSize = 128;
        private int defaultListBatchSize = 16;
        private Caches caches;
        private Triggers triggers = new TriggersImpl();

        @Override
        public JSqlClient.Builder setConnectionManager(ConnectionManager connectionManager) {
            this.connectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setSlaveConnectionManager(ConnectionManager connectionManager) {
            this.slaveConnectionManager = connectionManager;
            return this;
        }

        @Override
        public JSqlClient.Builder setDialect(Dialect dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public JSqlClient.Builder setExecutor(Executor executor) {
            this.executor = executor;
            return this;
        }

        @Override
        public JSqlClient.Builder setIdGenerator(IdGenerator idGenerator) {
            return this.setIdGenerator(null, idGenerator);
        }

        @Override
        public JSqlClient.Builder setIdGenerator(Class<?> entityType, IdGenerator idGenerator) {
            this.idGeneratorMap.put(entityType, idGenerator);
            return this;
        }

        @Override
        public JSqlClient.Builder addScalarProvider(ScalarProvider<?, ?> scalarProvider) {
            if (this.scalarProviderMap.containsKey(scalarProvider.getScalarType())) {
                throw new IllegalStateException("Cannot set scalar provider for scalar type \"" + scalarProvider.getScalarType() + "\" twice");
            }
            this.scalarProviderMap.put(scalarProvider.getScalarType(), scalarProvider);
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setDefaultListBatchSize(int size) {
            if (size < 1) {
                throw new IllegalStateException("size cannot be less than 1");
            }
            this.defaultListBatchSize = size;
            return this;
        }

        @Override
        public JSqlClient.Builder setCaches(Consumer<CacheConfig> block) {
            this.caches = CachesImpl.of(this.triggers, block);
            return this;
        }

        @Override
        public JSqlClient build() {
            return new JSqlClientImpl(this.connectionManager, this.slaveConnectionManager, this.dialect, this.executor, this.scalarProviderMap, this.idGeneratorMap, this.defaultBatchSize, this.defaultListBatchSize, this.caches, this.triggers);
        }
    }
}

