/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.runtime;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.ast.tuple.Tuple3;
import org.babyfish.jimmer.sql.ast.tuple.Tuple4;
import org.babyfish.jimmer.sql.ast.tuple.Tuple5;
import org.babyfish.jimmer.sql.ast.tuple.Tuple6;
import org.babyfish.jimmer.sql.ast.tuple.Tuple7;
import org.babyfish.jimmer.sql.ast.tuple.Tuple8;
import org.babyfish.jimmer.sql.ast.tuple.Tuple9;
import org.babyfish.jimmer.sql.runtime.DbNull;
import org.babyfish.jimmer.sql.runtime.ExecutionException;
import org.babyfish.jimmer.sql.runtime.ScalarProvider;

public class SqlBuilder {
    private JSqlClient sqlClient;
    private Set<Table<?>> usedTables;
    private SqlBuilder parent;
    private int childBuilderCount;
    private StringBuilder builder = new StringBuilder();
    private List<Object> variables = new ArrayList<Object>();
    private boolean terminated;

    public SqlBuilder(JSqlClient sqlClient) {
        this.sqlClient = sqlClient;
        this.usedTables = new HashSet();
    }

    private SqlBuilder(SqlBuilder parent) {
        this.sqlClient = parent.sqlClient;
        this.usedTables = parent.usedTables;
        this.parent = parent;
        ++parent.childBuilderCount;
    }

    public void useTable(Table<?> table) {
        if (table != null) {
            this.usedTables.add(table);
        }
    }

    public boolean isTableUsed(Table<?> table) {
        return this.usedTables.contains(table);
    }

    public SqlBuilder sql(String sql) {
        this.builder.append(sql);
        return this;
    }

    public <T> SqlBuilder variable(Class<T> type, T value) {
        if (value != null) {
            return this.variable(value);
        }
        return this.nullVariable(type);
    }

    public SqlBuilder variable(Object value) {
        this.validate();
        if (value instanceof Tuple2) {
            Tuple2 tuple = (Tuple2)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(")");
        } else if (value instanceof Tuple3) {
            Tuple3 tuple = (Tuple3)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(")");
        } else if (value instanceof Tuple4) {
            Tuple4 tuple = (Tuple4)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(")");
        } else if (value instanceof Tuple5) {
            Tuple5 tuple = (Tuple5)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(")");
        } else if (value instanceof Tuple6) {
            Tuple6 tuple = (Tuple6)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(")");
        } else if (value instanceof Tuple7) {
            Tuple7 tuple = (Tuple7)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).sql(")");
        } else if (value instanceof Tuple8) {
            Tuple8 tuple = (Tuple8)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).sql(")");
        } else if (value instanceof Tuple9) {
            Tuple9 tuple = (Tuple9)value;
            this.sql("(").singleVariable(Objects.requireNonNull(tuple.get_1(), "tuple.get_1 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_2(), "tuple.get_2 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_3(), "tuple.get_3 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_4(), "tuple.get_4 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_5(), "tuple.get_5 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_6(), "tuple.get_6 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_7(), "tuple.get_7 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_8(), "tuple.get_8 cannot be null")).sql(", ").singleVariable(Objects.requireNonNull(tuple.get_9(), "tuple.get_9 cannot be null")).sql(")");
        } else {
            this.singleVariable(value);
        }
        return this;
    }

    private SqlBuilder singleVariable(Object value) {
        if (value instanceof DbNull) {
            throw new ExecutionException("Cannot add variable whose type is " + DbNull.class.getName());
        }
        ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(value.getClass());
        Object finalValue = scalarProvider != null ? scalarProvider.toSql(value) : value;
        this.builder.append('?');
        this.variables.add(finalValue);
        return this;
    }

    public SqlBuilder nullVariable(ImmutableProp prop) {
        this.validate();
        ImmutableType targetType = prop.getTargetType();
        if (targetType == null) {
            return this.nullVariable(prop.getElementClass());
        }
        return this.nullVariable(targetType.getIdProp().getElementClass());
    }

    public SqlBuilder nullVariable(Class<?> type) {
        this.validate();
        ScalarProvider scalarProvider = this.sqlClient.getScalarProvider(type);
        DbNull finalValue = scalarProvider != null ? new DbNull(scalarProvider.getSqlType()) : new DbNull(type);
        this.builder.append('?');
        this.variables.add(finalValue);
        return this;
    }

    public SqlBuilder createChildBuilder() {
        return new SqlBuilder(this);
    }

    public Tuple2<String, List<Object>> build() {
        return this.build(null);
    }

    public Tuple2<String, List<Object>> build(Function<Tuple2<String, List<Object>>, Tuple2<String, List<Object>>> transformer) {
        SqlBuilder p;
        this.validate();
        Tuple2<String, List<Object>> result = new Tuple2<String, List<Object>>(this.builder.toString(), this.variables);
        if (transformer != null) {
            result = transformer.apply(result);
        }
        if ((p = this.parent) != null) {
            p.builder.append(result.get_1());
            p.variables.addAll((Collection<Object>)result.get_2());
            while (p != null) {
                --p.childBuilderCount;
                p = p.parent;
            }
        }
        this.terminated = true;
        return result;
    }

    private void validate() {
        if (this.childBuilderCount != 0) {
            throw new IllegalStateException("Internal bug: Cannot change sqlbuilder because there are some child builders");
        }
        if (this.terminated) {
            throw new IllegalStateException("Internal bug: Current build has been terminated");
        }
    }
}

