/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event.binlog;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.babyfish.jimmer.jackson.DeserializeUtils;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.DraftSpi;
import org.babyfish.jimmer.runtime.Internal;

class BinLogDeserializer
extends StdDeserializer<Object> {
    private final ImmutableType immutableType;

    public BinLogDeserializer(ImmutableType immutableType) {
        super(immutableType.getJavaClass());
        this.immutableType = immutableType;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
        JsonNode node = (JsonNode)jp.getCodec().readTree(jp);
        return Internal.produce((ImmutableType)this.immutableType, null, draft -> {
            Iterator itr = node.fields();
            while (itr.hasNext()) {
                ImmutableProp targetIdProp;
                Object valueId;
                Map.Entry fieldEntry = (Map.Entry)itr.next();
                String columnName = (String)fieldEntry.getKey();
                JsonNode childNode = (JsonNode)fieldEntry.getValue();
                ImmutableProp prop = this.immutableType.getPropByColumnName(columnName);
                Object value = prop.isAssociation() ? ((valueId = DeserializeUtils.readTreeAsValue((DeserializationContext)ctx, (JsonNode)childNode, (JavaType)SimpleType.constructUnsafe((Class)(targetIdProp = prop.getTargetType().getIdProp()).getElementClass()))) == null ? null : Internal.produce((ImmutableType)prop.getTargetType(), null, targetDraft -> ((DraftSpi)targetDraft).__set(targetIdProp.getId(), valueId))) : DeserializeUtils.readTreeAsValue((DeserializationContext)ctx, (JsonNode)childNode, (JavaType)SimpleType.constructUnsafe((Class)prop.getElementClass()));
                ((DraftSpi)draft).__set(prop.getId(), value);
            }
        });
    }
}

