/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.event.AssociationEvent;
import org.babyfish.jimmer.sql.event.AssociationListener;
import org.babyfish.jimmer.sql.event.EntityEvent;
import org.babyfish.jimmer.sql.event.EntityListener;
import org.babyfish.jimmer.sql.event.Utils;

class ForeignKeyAssociationListenerProxy
implements EntityListener<ImmutableSpi> {
    private final ImmutableProp prop;
    private final AssociationListener listener;

    ForeignKeyAssociationListenerProxy(ImmutableProp prop, AssociationListener listener) {
        this.prop = prop;
        this.listener = listener;
    }

    @Override
    public void onChange(EntityEvent<ImmutableSpi> e) {
        ImmutableProp fkProp = Utils.primaryAssociationProp(this.prop);
        Object detachedTargetId = null;
        Object attachedTargetId = null;
        int fkPropId = fkProp.getId();
        int parentIdPropId = fkProp.getTargetType().getIdProp().getId();
        ImmutableSpi oldEntity = e.getOldEntity();
        ImmutableSpi newEntity = e.getNewEntity();
        if (oldEntity != null) {
            if (!oldEntity.__isLoaded(fkPropId)) {
                return;
            }
            ImmutableSpi detachedTarget = (ImmutableSpi)oldEntity.__get(fkPropId);
            if (detachedTarget != null) {
                detachedTargetId = detachedTarget.__get(parentIdPropId);
            }
        }
        if (newEntity != null) {
            if (!newEntity.__isLoaded(fkPropId)) {
                return;
            }
            ImmutableSpi attachedTarget = (ImmutableSpi)newEntity.__get(fkPropId);
            if (attachedTarget != null) {
                attachedTargetId = attachedTarget.__get(parentIdPropId);
            }
        }
        if (detachedTargetId == attachedTargetId) {
            return;
        }
        if (fkProp == this.prop) {
            this.listener.onChange(new AssociationEvent(this.prop, e.getId(), detachedTargetId, attachedTargetId));
        } else {
            if (detachedTargetId != null) {
                this.listener.onChange(new AssociationEvent(this.prop, detachedTargetId, e.getId(), null));
            }
            if (attachedTargetId != null) {
                this.listener.onChange(new AssociationEvent(this.prop, attachedTargetId, null, e.getId()));
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.prop, this.listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ForeignKeyAssociationListenerProxy that = (ForeignKeyAssociationListenerProxy)o;
        return this.prop.equals(that.prop) && this.listener.equals(that.listener);
    }

    public String toString() {
        return "ForeignKeyAssociationProxy{prop=" + this.prop + ", listener=" + this.listener + '}';
    }
}

