/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.event;

import java.util.Objects;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.event.EventType;

public class EntityEvent<E> {
    private Object id;
    private E oldEntity;
    private E newEntity;

    public EntityEvent(E oldEntity, E newEntity) {
        if (oldEntity == null && newEntity == null) {
            throw new IllegalArgumentException("Both oldEntity and newEntity are null");
        }
        if (oldEntity != null && !(oldEntity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("oldEntity is not immutable object");
        }
        if (newEntity != null && !(newEntity instanceof ImmutableSpi)) {
            throw new IllegalArgumentException("newEntity is not immutable object");
        }
        ImmutableSpi oe = (ImmutableSpi)oldEntity;
        ImmutableSpi ne = (ImmutableSpi)newEntity;
        if (oe != null && ne != null && oe.__type() != ne.__type()) {
            throw new IllegalArgumentException("oldEntity and newEntity must belong to same type");
        }
        int idPropId = (oe != null ? oe : ne).__type().getIdProp().getId();
        Object oldId = null;
        if (oe != null && oe.__isLoaded(idPropId)) {
            oldId = oe.__get(idPropId);
        }
        Object newId = null;
        if (ne != null && ne.__isLoaded(idPropId)) {
            newId = ne.__get(idPropId);
        }
        if (oldId == null && newId == null) {
            throw new IllegalStateException("Id is not specified");
        }
        if (oldId != null && newId != null && !oldId.equals(newId)) {
            throw new IllegalStateException("Conflict ids in old entity and new entity");
        }
        this.id = oldId != null ? oldId : newId;
        this.oldEntity = oldEntity;
        this.newEntity = newEntity;
    }

    public E getOldEntity() {
        return this.oldEntity;
    }

    public E getNewEntity() {
        return this.newEntity;
    }

    public Object getId() {
        return this.id;
    }

    public ImmutableType getImmutableType() {
        E oe = this.oldEntity;
        if (oe != null) {
            return ((ImmutableSpi)oe).__type();
        }
        return ((ImmutableSpi)this.newEntity).__type();
    }

    public EventType getEventType() {
        if (this.oldEntity == null) {
            return EventType.INSERT;
        }
        if (this.newEntity == null) {
            return EventType.DELETE;
        }
        return EventType.UPDATE;
    }

    public int hashCode() {
        return Objects.hash(this.oldEntity, this.newEntity);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityEvent event = (EntityEvent)o;
        return Objects.equals(this.oldEntity, event.oldEntity) && Objects.equals(this.newEntity, event.newEntity);
    }

    public String toString() {
        return "Event{oldEntity=" + this.oldEntity + ", newEntity=" + this.newEntity + '}';
    }
}

