/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.SimpleType;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import org.babyfish.jimmer.jackson.ImmutableModule;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.cache.ValueSerializationException;
import org.jetbrains.annotations.NotNull;

public class ValueSerializer<T> {
    private static final byte[] NULL_BYTES = "<null>".getBytes(StandardCharsets.UTF_8);
    private final ObjectMapper mapper;
    private JavaType valueType;

    public ValueSerializer(@NotNull ImmutableType type) {
        this(type, null, null);
    }

    public ValueSerializer(@NotNull ImmutableProp prop) {
        this(null, prop, null);
    }

    public ValueSerializer(@NotNull ImmutableType type, ObjectMapper mapper) {
        this(type, null, mapper);
    }

    public ValueSerializer(@NotNull ImmutableProp prop, ObjectMapper mapper) {
        this(null, prop, mapper);
    }

    private ValueSerializer(ImmutableType type, ImmutableProp prop, ObjectMapper mapper) {
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("Internal bug: nullity of type and prop must be different");
        }
        ObjectMapper clonedMapper = mapper != null ? new ObjectMapper(mapper){} : new ObjectMapper();
        clonedMapper.registerModule((Module)new ImmutableModule());
        this.mapper = clonedMapper;
        if (prop != null) {
            SimpleType targetIdType = SimpleType.constructUnsafe((Class)prop.getTargetType().getIdProp().getElementClass());
            this.valueType = prop.isEntityList() ? CollectionType.construct(List.class, null, null, null, (JavaType)targetIdType) : targetIdType;
        } else {
            this.valueType = SimpleType.constructUnsafe((Class)type.getJavaClass());
        }
    }

    public byte[] serialize(T value) {
        if (value == null) {
            return (byte[])NULL_BYTES.clone();
        }
        try {
            return this.mapper.writeValueAsBytes(value);
        }
        catch (JsonProcessingException ex) {
            throw new ValueSerializationException(ex);
        }
    }

    public T deserialize(byte[] value) {
        if (value == null || value.length == 0 || Arrays.equals(value, NULL_BYTES)) {
            return null;
        }
        try {
            return (T)this.mapper.readValue(value, this.valueType);
        }
        catch (IOException ex) {
            throw new ValueSerializationException(ex);
        }
    }
}

