/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.jetbrains.annotations.NotNull;

class LocatedCacheImpl<K, V>
implements LocatedCache<K, V> {
    private static final ThreadLocal<Set<LocatedCacheImpl<?, ?>>> LOADING_CACHES_LOCAL = new ThreadLocal();
    private final Cache<K, V> raw;
    private final ImmutableType type;
    private final ImmutableProp prop;

    public LocatedCacheImpl(Cache<K, V> raw, ImmutableType type, ImmutableProp prop) {
        if (type == null == (prop == null)) {
            throw new IllegalArgumentException("The nullity of type and prop must be different");
        }
        if (prop != null && !prop.isAssociation()) {
            throw new IllegalArgumentException("The prop \"" + prop + "\" is not association");
        }
        this.raw = Objects.requireNonNull(raw, "raw cannot be null");
        this.type = type;
        this.prop = prop;
    }

    public static <K, V> LocatedCacheImpl<K, V> wrap(Cache<K, V> cache, ImmutableType type) {
        return LocatedCacheImpl.wrap(cache, type, null);
    }

    public static <K, V> LocatedCacheImpl<K, V> wrap(Cache<K, V> cache, ImmutableProp prop) {
        return LocatedCacheImpl.wrap(cache, null, prop);
    }

    private static <K, V> LocatedCacheImpl<K, V> wrap(Cache<K, V> cache, ImmutableType type, ImmutableProp prop) {
        if (cache == null) {
            return null;
        }
        if (cache instanceof LocatedCache) {
            LocatedCacheImpl wrapper = (LocatedCacheImpl)cache;
            if (wrapper.type == type && wrapper.prop == prop) {
                return wrapper;
            }
            cache = ((LocatedCacheImpl)cache).raw;
        }
        return new LocatedCacheImpl<K, V>(cache, type, prop);
    }

    public static <K, V> LocatedCache<K, V> export(LocatedCache<K, V> cacheWrapper) {
        Set<LocatedCacheImpl<?, ?>> disabledCaches;
        if (cacheWrapper != null && (disabledCaches = LOADING_CACHES_LOCAL.get()) != null && disabledCaches.contains(cacheWrapper)) {
            return null;
        }
        return cacheWrapper;
    }

    public static <K, V> Cache<K, V> unwrap(Cache<K, V> cache) {
        if (cache instanceof LocatedCacheImpl) {
            LocatedCacheImpl wrapper = (LocatedCacheImpl)cache;
            return wrapper.raw;
        }
        return cache;
    }

    @Override
    public ImmutableType getType() {
        return this.type;
    }

    @Override
    public ImmutableProp getProp() {
        return this.prop;
    }

    @Override
    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> keys, @NotNull CacheEnvironment<K, V> env) {
        return this.loading(() -> {
            Map<K, V> valueMap = this.raw.getAll(keys, env);
            for (V value : valueMap.values()) {
                this.validateResult(value);
            }
            return valueMap;
        });
    }

    @Override
    public void deleteAll(@NotNull Collection<K> keys, String reason) {
        this.raw.deleteAll(keys, reason);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <R> R loading(Supplier<R> block) {
        Set<LocatedCacheImpl<?, ?>> disabledCaches = LOADING_CACHES_LOCAL.get();
        if (disabledCaches == null) {
            disabledCaches = new HashSet();
            LOADING_CACHES_LOCAL.set(disabledCaches);
        }
        disabledCaches.add(this);
        try {
            R r = block.get();
            return r;
        }
        finally {
            if (disabledCaches.size() > 1) {
                disabledCaches.remove(this);
            } else {
                LOADING_CACHES_LOCAL.remove();
            }
        }
    }

    private void validateResult(Object result) {
        if (result != null) {
            if (this.prop == null) {
                if (!(result instanceof ImmutableSpi)) {
                    throw new IllegalArgumentException("Object cache for \"" + this.type + "\" must return object");
                }
            } else if (this.prop.isEntityList()) {
                if (!(result instanceof List)) {
                    throw new IllegalArgumentException("Association id list cache for \"" + this.prop + "\" must return id list");
                }
                List ids = (List)result;
                for (Object id : ids) {
                    if (!(id instanceof ImmutableSpi) && !(id instanceof List)) continue;
                    throw new IllegalArgumentException("Association id list cache for \"" + this.prop + "\" returns a list but some elements is not simple id value");
                }
            } else if (result instanceof ImmutableSpi || result instanceof List) {
                throw new IllegalArgumentException("Association id cache for \"" + this.prop + "\" must return simple id value");
            }
        }
    }

    public int hashCode() {
        return Objects.hash(this.raw, this.type, this.prop);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocatedCacheImpl that = (LocatedCacheImpl)o;
        return this.raw.equals(that.raw) && Objects.equals(this.type, that.type) && Objects.equals(this.prop, that.prop);
    }

    public String toString() {
        return "CacheWrapper{raw=" + this.raw + ", type=" + this.type + ", prop=" + this.prop + '}';
    }
}

