/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.meta.impl.DatabaseIdentifiers;
import org.babyfish.jimmer.runtime.ImmutableSpi;
import org.babyfish.jimmer.sql.Triggers;
import org.babyfish.jimmer.sql.association.meta.AssociationType;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;
import org.babyfish.jimmer.sql.cache.Cache;
import org.babyfish.jimmer.sql.cache.CacheConfig;
import org.babyfish.jimmer.sql.cache.CacheDisableConfig;
import org.babyfish.jimmer.sql.cache.CacheOperator;
import org.babyfish.jimmer.sql.cache.Caches;
import org.babyfish.jimmer.sql.cache.LocatedCache;
import org.babyfish.jimmer.sql.cache.LocatedCacheImpl;
import org.babyfish.jimmer.sql.event.binlog.BinLogParser;
import org.babyfish.jimmer.sql.meta.MiddleTable;

public class CachesImpl
implements Caches {
    private final Triggers triggers;
    private final Map<ImmutableType, LocatedCacheImpl<?, ?>> objectCacheMap;
    private final Map<ImmutableProp, LocatedCacheImpl<?, ?>> associationCacheMap;
    private final Map<String, ImmutableType> tableNameTypeMap;
    private final CacheOperator operator;
    private final BinLogParser binLogParser;
    private final boolean disableAll;
    private final Set<ImmutableType> disabledTypes;
    private final Set<ImmutableProp> disabledProps;

    /*
     * WARNING - void declaration
     */
    public CachesImpl(Triggers triggers, Map<ImmutableType, Cache<?, ?>> objectCacheMap, Map<ImmutableProp, Cache<?, ?>> associationCacheMap, CacheOperator operator, BinLogParser binLogParser) {
        HashMap<String, ImmutableType> tableNameTypeMap = new HashMap<String, ImmutableType>();
        for (ImmutableType immutableType : objectCacheMap.keySet()) {
            String string = DatabaseIdentifiers.standardIdentifier((String)immutableType.getTableName());
            ImmutableType oldType = tableNameTypeMap.put(string, immutableType);
            if (oldType == null) continue;
            throw new IllegalArgumentException("Illegal mapping, the table \"" + string + "\" is shared by both \"" + oldType + "\" and \"" + immutableType + "\"");
        }
        for (ImmutableProp immutableProp : associationCacheMap.keySet()) {
            AssociationType associationType;
            String tableName;
            ImmutableType oldType;
            void var8_12;
            if (immutableProp.getMappedBy() != null) {
                ImmutableProp immutableProp2 = immutableProp.getMappedBy();
            }
            if (!(var8_12.getStorage() instanceof MiddleTable) || (oldType = (ImmutableType)tableNameTypeMap.put(tableName = DatabaseIdentifiers.standardIdentifier((String)(associationType = AssociationType.of((ImmutableProp)var8_12)).getTableName()), associationType)) == null || oldType == associationType) continue;
            throw new IllegalArgumentException("Illegal mapping, the table \"" + tableName + "\" is shared by both \"" + oldType + "\" and \"" + associationType + "\"");
        }
        LinkedHashMap objectCacheWrapperMap = new LinkedHashMap();
        for (Map.Entry<ImmutableType, Cache<?, ?>> entry : objectCacheMap.entrySet()) {
            ImmutableType type = entry.getKey();
            objectCacheWrapperMap.put(type, this.wrapObjectCache(triggers, entry.getValue(), type));
        }
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        for (Map.Entry<ImmutableProp, Cache<?, ?>> e : associationCacheMap.entrySet()) {
            ImmutableProp prop = e.getKey();
            linkedHashMap.put(prop, this.wrapAssociationCache(triggers, e.getValue(), prop));
        }
        this.triggers = triggers;
        this.objectCacheMap = objectCacheWrapperMap;
        this.associationCacheMap = linkedHashMap;
        this.tableNameTypeMap = tableNameTypeMap;
        this.operator = operator;
        this.binLogParser = binLogParser;
        this.disableAll = false;
        this.disabledTypes = Collections.emptySet();
        this.disabledProps = Collections.emptySet();
    }

    public CachesImpl(CachesImpl base, CacheDisableConfig cfg) {
        this.triggers = base.triggers;
        this.objectCacheMap = base.objectCacheMap;
        this.associationCacheMap = base.associationCacheMap;
        this.tableNameTypeMap = base.tableNameTypeMap;
        this.operator = base.operator;
        this.binLogParser = base.binLogParser;
        this.disableAll = cfg.isDisableAll();
        this.disabledTypes = cfg.getDisabledTypes();
        this.disabledProps = cfg.getDisabledProps();
    }

    public <K, V> LocatedCache<K, V> getObjectCache(ImmutableType type) {
        if (this.disableAll || this.disabledTypes.contains(type)) {
            return null;
        }
        return LocatedCacheImpl.export(this.objectCacheMap.get(type));
    }

    public <K, V> LocatedCache<K, V> getAssociationCache(ImmutableProp prop) {
        if (this.disableAll || this.disabledProps.contains(prop) || this.disabledTypes.contains(prop.getTargetType())) {
            return null;
        }
        return LocatedCacheImpl.export(this.associationCacheMap.get(prop));
    }

    @Override
    public boolean isAffectedBy(String tableName) {
        return this.tableNameTypeMap.containsKey(DatabaseIdentifiers.databaseIdentifier((String)tableName));
    }

    @Override
    public void invalidateByBinLog(String tableName, JsonNode oldData, JsonNode newData) {
        boolean isNewNull;
        boolean isOldNull = oldData == null || oldData.isNull();
        boolean bl = isNewNull = newData == null || newData.isNull();
        if (isOldNull && isNewNull) {
            return;
        }
        ImmutableType type = this.tableNameTypeMap.get(DatabaseIdentifiers.databaseIdentifier((String)tableName));
        if (type == null) {
            throw new IllegalArgumentException("Illegal table name \"" + tableName + "\", it is not managed by cache");
        }
        if (type instanceof AssociationType) {
            if (isOldNull) {
                AssociationType associationType = (AssociationType)type;
                Tuple2 idPair = this.binLogParser.parseIdPair(associationType, newData);
                this.triggers.fireMiddleTableInsert(associationType.getBaseProp(), idPair.get_1(), idPair.get_2());
            } else {
                AssociationType associationType = (AssociationType)type;
                Tuple2 idPair = this.binLogParser.parseIdPair(associationType, oldData);
                this.triggers.fireMiddleTableDelete(associationType.getBaseProp(), idPair.get_1(), idPair.get_2());
            }
        } else {
            this.triggers.fireEntityTableChange(this.binLogParser.parseEntity(type, oldData), this.binLogParser.parseEntity(type, newData));
        }
    }

    private LocatedCacheImpl<?, ?> wrapObjectCache(Triggers triggers, Cache<?, ?> cache, ImmutableType type) {
        if (cache == null) {
            return null;
        }
        LocatedCacheImpl<?, ?> wrapper = LocatedCacheImpl.wrap(cache, type);
        triggers.addEntityListener(type, e -> {
            ImmutableSpi oldEntity = (ImmutableSpi)e.getOldEntity();
            if (oldEntity != null) {
                Object id = e.getId();
                if (this.operator != null) {
                    this.operator.delete(wrapper, id);
                } else {
                    wrapper.delete(id);
                }
            }
        });
        return wrapper;
    }

    private LocatedCacheImpl<?, ?> wrapAssociationCache(Triggers triggers, Cache<?, ?> cache, ImmutableProp prop) {
        if (cache == null) {
            return null;
        }
        LocatedCacheImpl<?, ?> wrapper = LocatedCacheImpl.wrap(cache, prop);
        triggers.addAssociationListener(prop, e -> {
            Object id = e.getSourceId();
            if (this.operator != null) {
                this.operator.delete(wrapper, id);
            } else {
                wrapper.delete(id);
            }
        });
        return wrapper;
    }

    public static Caches of(Triggers triggers, Consumer<CacheConfig> block) {
        CacheConfig cfg = new CacheConfig();
        if (block != null) {
            block.accept(cfg);
        }
        return cfg.build(triggers);
    }
}

