/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.cache;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.babyfish.jimmer.sql.cache.CacheEnvironment;
import org.jetbrains.annotations.NotNull;

public interface Cache<K, V> {
    @NotNull
    default public Optional<V> get(@NotNull K key, @NotNull CacheEnvironment<K, V> env) {
        Map<K, V> map = this.getAll(Collections.singleton(key), env);
        V value = map.get(key);
        if (value == null && map.containsKey(key)) {
            return null;
        }
        return Optional.ofNullable(value);
    }

    @NotNull
    public Map<K, V> getAll(@NotNull Collection<K> var1, @NotNull CacheEnvironment<K, V> var2);

    default public void delete(@NotNull K key) {
        this.deleteAll(Collections.singleton(key), null);
    }

    default public void delete(@NotNull K key, String reason) {
        this.deleteAll(Collections.singleton(key), reason);
    }

    default public void deleteAll(@NotNull Collection<K> keys) {
        this.deleteAll(keys, null);
    }

    public void deleteAll(@NotNull Collection<K> var1, String var2);
}

