/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.query;

import java.util.Collections;
import java.util.List;
import org.babyfish.jimmer.sql.ast.Selection;
import org.babyfish.jimmer.sql.ast.impl.ExpressionImplementor;
import org.babyfish.jimmer.sql.ast.tuple.Tuple2;

class TypedQueryData {
    private static final Package TUPLE_PACKAGE = Tuple2.class.getPackage();
    private List<Selection<?>> selections;
    private List<Selection<?>> oldSelections;
    private boolean distinct;
    private int limit;
    private int offset;
    private boolean withoutSortingAndPaging;
    private boolean forUpdate;

    public TypedQueryData(List<Selection<?>> selections) {
        this.selections = TypedQueryData.processSelections(selections);
        this.limit = Integer.MAX_VALUE;
    }

    private TypedQueryData(List<Selection<?>> selections, List<Selection<?>> oldSelections, boolean distinct, int limit, int offset, boolean withoutSortingAndPaging, boolean forUpdate) {
        this.selections = selections;
        this.oldSelections = oldSelections;
        this.distinct = distinct;
        this.limit = limit;
        this.offset = offset;
        this.withoutSortingAndPaging = withoutSortingAndPaging;
        this.forUpdate = forUpdate;
    }

    public List<Selection<?>> getSelections() {
        return this.selections;
    }

    public List<Selection<?>> getOldSelections() {
        return this.oldSelections;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public boolean isWithoutSortingAndPaging() {
        return this.withoutSortingAndPaging;
    }

    public boolean isForUpdate() {
        return this.forUpdate;
    }

    public TypedQueryData reselect(List<Selection<?>> selections) {
        return new TypedQueryData(TypedQueryData.processSelections(selections), this.selections, this.distinct, this.limit, this.offset, this.withoutSortingAndPaging, this.forUpdate);
    }

    public TypedQueryData distinct() {
        return new TypedQueryData(this.selections, this.oldSelections, true, this.limit, this.offset, this.withoutSortingAndPaging, this.forUpdate);
    }

    public TypedQueryData limit(int limit, int offset) {
        return new TypedQueryData(this.selections, this.oldSelections, this.distinct, limit, offset, this.withoutSortingAndPaging, this.forUpdate);
    }

    public TypedQueryData withoutSortingAndPaging() {
        return new TypedQueryData(this.selections, this.oldSelections, this.distinct, this.limit, this.offset, true, this.forUpdate);
    }

    public TypedQueryData forUpdate() {
        return new TypedQueryData(this.selections, this.oldSelections, this.distinct, this.limit, this.offset, this.withoutSortingAndPaging, true);
    }

    private static List<Selection<?>> processSelections(List<Selection<?>> selections) {
        for (Selection<?> selection : selections) {
            Class type;
            if (!(selection instanceof ExpressionImplementor) || !TUPLE_PACKAGE.equals((type = ((ExpressionImplementor)selection).getType()).getPackage())) continue;
            throw new IllegalArgumentException("Tuple expression cannot be selected");
        }
        return Collections.unmodifiableList(selections);
    }
}

