/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.DeleteAction;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.impl.mutation.Deleter;
import org.babyfish.jimmer.sql.ast.mutation.DeleteCommand;
import org.babyfish.jimmer.sql.ast.mutation.DeleteResult;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.Column;
import org.babyfish.jimmer.sql.runtime.Converters;

class DeleteCommandImpl
implements DeleteCommand {
    private final JSqlClient sqlClient;
    private final Connection con;
    private final ImmutableType immutableType;
    private final Collection<?> ids;
    private final Data data;

    public DeleteCommandImpl(JSqlClient sqlClient, Connection con, ImmutableType immutableType, Collection<?> ids) {
        Class idClass = immutableType.getIdProp().getElementClass();
        for (Object id : ids) {
            if (Converters.tryConvert(id, idClass) != null) continue;
            throw new IllegalArgumentException("The type of \"" + immutableType.getIdProp() + "\" must be \"" + idClass.getName() + "\"");
        }
        this.sqlClient = sqlClient;
        this.con = con;
        this.immutableType = immutableType;
        this.ids = ids;
        this.data = new Data(sqlClient).freeze();
    }

    public DeleteCommandImpl(DeleteCommandImpl base, Data data) {
        this.sqlClient = base.sqlClient;
        this.con = base.con;
        this.immutableType = base.immutableType;
        this.ids = base.ids;
        this.data = data.freeze();
    }

    @Override
    public DeleteCommand configure(Consumer<DeleteCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (newData.deleteActionMap.isEmpty()) {
            return this;
        }
        return new DeleteCommandImpl(this, newData);
    }

    @Override
    public DeleteResult execute() {
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    @Override
    public DeleteResult execute(Connection con) {
        if (con != null) {
            return this.executeImpl(con);
        }
        if (this.con != null) {
            return this.executeImpl(this.con);
        }
        return this.sqlClient.getConnectionManager().execute(this::executeImpl);
    }

    private DeleteResult executeImpl(Connection con) {
        Deleter deleter = new Deleter(this.data, con);
        deleter.addPreHandleInput(this.immutableType, this.ids);
        return deleter.execute();
    }

    static class Data
    implements DeleteCommand.Cfg {
        private JSqlClient sqlClient;
        private Map<ImmutableProp, DeleteAction> deleteActionMap;
        private boolean frozen;

        Data(JSqlClient sqlClient) {
            this.sqlClient = sqlClient;
            this.deleteActionMap = new LinkedHashMap<ImmutableProp, DeleteAction>();
        }

        Data(JSqlClient sqlClient, Map<ImmutableProp, DeleteAction> deleteActionMap) {
            this.sqlClient = sqlClient;
            this.deleteActionMap = deleteActionMap != null ? new LinkedHashMap<ImmutableProp, DeleteAction>(deleteActionMap) : new LinkedHashMap<ImmutableProp, DeleteAction>();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.deleteActionMap = new LinkedHashMap<ImmutableProp, DeleteAction>(base.deleteActionMap);
        }

        public JSqlClient getSqlClient() {
            return this.sqlClient;
        }

        public DeleteAction getDeleteAction(ImmutableProp prop) {
            DeleteAction action = this.deleteActionMap.get(prop);
            return action != null ? action : prop.getDeleteAction();
        }

        public Data freeze() {
            if (!this.frozen) {
                this.deleteActionMap = Collections.unmodifiableMap(this.deleteActionMap);
                this.frozen = true;
            }
            return this;
        }

        @Override
        public DeleteCommand.Cfg setDeleteAction(ImmutableProp prop, DeleteAction deleteAction) {
            if (this.frozen) {
                throw new IllegalStateException("The configuration is frozen");
            }
            if (!prop.isReference() || !(prop.getStorage() instanceof Column)) {
                throw new IllegalArgumentException("'" + prop + "' must be an reference property bases on foreign key");
            }
            if (deleteAction == DeleteAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            this.deleteActionMap.put(prop, deleteAction);
            return this;
        }

        @Override
        public DeleteCommand.Cfg setDeleteAction(Class<?> entityType, String prop, DeleteAction deleteAction) {
            ImmutableType immutableType = ImmutableType.get(entityType);
            ImmutableProp immutableProp = (ImmutableProp)immutableType.getProps().get(prop);
            if (immutableProp == null || !immutableProp.isReference()) {
                throw new IllegalArgumentException("'" + prop + "' is not reference property of \"" + entityType.getName() + "\"");
            }
            return this.setDeleteAction(immutableProp, deleteAction);
        }

        @Override
        public <T extends Table<?>> DeleteCommand.Cfg setDeleteAction(Class<T> tableType, Function<T, Table<?>> block, DeleteAction deleteAction) {
            return this.setDeleteAction(ImmutableProps.join(tableType, block), deleteAction);
        }
    }
}

