/*
 * Decompiled with CFR 0.152.
 */
package org.babyfish.jimmer.sql.ast.impl.mutation;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import org.babyfish.jimmer.meta.ImmutableProp;
import org.babyfish.jimmer.meta.ImmutableType;
import org.babyfish.jimmer.sql.DeleteAction;
import org.babyfish.jimmer.sql.ImmutableProps;
import org.babyfish.jimmer.sql.JSqlClient;
import org.babyfish.jimmer.sql.ast.PropExpression;
import org.babyfish.jimmer.sql.ast.mutation.AbstractEntitySaveCommand;
import org.babyfish.jimmer.sql.ast.mutation.SaveMode;
import org.babyfish.jimmer.sql.ast.table.Table;
import org.babyfish.jimmer.sql.meta.Column;

abstract class AbstractEntitySaveCommandImpl
implements AbstractEntitySaveCommand {
    final JSqlClient sqlClient;
    final Connection con;
    final Data data;

    AbstractEntitySaveCommandImpl(JSqlClient sqlClient, Connection con, Data data) {
        this.sqlClient = sqlClient;
        this.con = con;
        this.data = data != null ? data.freeze() : new Data(sqlClient).freeze();
    }

    @Override
    public AbstractEntitySaveCommand configure(Consumer<AbstractEntitySaveCommand.Cfg> block) {
        Data newData = new Data(this.data);
        block.accept(newData);
        if (newData.mode == SaveMode.UPSERT && newData.keyPropMultiMap.isEmpty() && !newData.autoAttachingAll && newData.deleteActionMap.isEmpty() && newData.autoAttachingSet.isEmpty()) {
            return this;
        }
        return this.create(newData);
    }

    abstract AbstractEntitySaveCommand create(Data var1);

    static class Data
    implements AbstractEntitySaveCommand.Cfg {
        private JSqlClient sqlClient;
        private boolean frozen;
        private SaveMode mode;
        private Map<ImmutableType, Set<ImmutableProp>> keyPropMultiMap;
        private boolean autoAttachingAll;
        private Set<ImmutableProp> autoAttachingSet;
        private Map<ImmutableProp, DeleteAction> deleteActionMap;

        Data(JSqlClient sqlClient) {
            this.sqlClient = sqlClient;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>();
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>();
            this.deleteActionMap = new LinkedHashMap<ImmutableProp, DeleteAction>();
        }

        Data(Data base) {
            this.sqlClient = base.sqlClient;
            this.mode = SaveMode.UPSERT;
            this.keyPropMultiMap = new LinkedHashMap<ImmutableType, Set<ImmutableProp>>(base.keyPropMultiMap);
            this.autoAttachingAll = base.autoAttachingAll;
            this.autoAttachingSet = new LinkedHashSet<ImmutableProp>(base.autoAttachingSet);
            this.deleteActionMap = new LinkedHashMap<ImmutableProp, DeleteAction>(base.deleteActionMap);
        }

        public JSqlClient getSqlClient() {
            return this.sqlClient;
        }

        public SaveMode getMode() {
            return this.mode;
        }

        public Set<ImmutableProp> getKeyProps(ImmutableType type) {
            Set<ImmutableProp> keyProps = this.keyPropMultiMap.get(type);
            if (keyProps != null) {
                return keyProps;
            }
            return type.getKeyProps();
        }

        public boolean isAutoAttachingProp(ImmutableProp prop) {
            return this.autoAttachingAll || this.autoAttachingSet.contains(prop);
        }

        public DeleteAction getDeleteAction(ImmutableProp prop) {
            DeleteAction action = this.deleteActionMap.get(prop);
            return action != null ? action : prop.getDeleteAction();
        }

        Map<ImmutableProp, DeleteAction> deleteActionMap() {
            return this.deleteActionMap;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setMode(SaveMode mode) {
            this.validate();
            this.mode = Objects.requireNonNull(mode, "mode cannot be null");
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setKeyProps(ImmutableProp ... props) {
            this.validate();
            ImmutableType type = null;
            LinkedHashSet<ImmutableProp> set = new LinkedHashSet<ImmutableProp>();
            for (ImmutableProp prop : props) {
                if (prop == null) continue;
                if (prop.isId()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is id property");
                }
                if (prop.isVersion()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is version property");
                }
                if (prop.isAssociation() || !(prop.getStorage() instanceof Column)) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is not a scalar property with storage");
                }
                if (prop.isNullable()) {
                    throw new IllegalArgumentException("'" + prop + "' cannot be key property because it is nullable");
                }
                if (type == null) {
                    type = prop.getDeclaringType();
                } else if (type != prop.getDeclaringType()) {
                    throw new IllegalArgumentException("all key properties must belong to one type");
                }
                set.add(prop);
            }
            if (type != null) {
                this.keyPropMultiMap.put(type, set);
            }
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setKeyProps(Class<?> entityType, String ... props) {
            ImmutableType type = ImmutableType.get(entityType);
            return this.setKeyProps((ImmutableProp[])Arrays.stream(props).map(arg_0 -> ((ImmutableType)type).getProp(arg_0)).toArray(ImmutableProp[]::new));
        }

        @Override
        public <T extends Table<?>> AbstractEntitySaveCommand.Cfg setKeyProps(Class<T> tableType, Consumer<AbstractEntitySaveCommand.KeyPropCfg<T>> block) {
            KeyPropCfgImpl<T> keyPropCfg = new KeyPropCfgImpl<T>(tableType);
            block.accept(keyPropCfg);
            return this.setKeyProps(keyPropCfg.getProps().toArray(new ImmutableProp[0]));
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttachingAll() {
            this.autoAttachingAll = true;
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttaching(ImmutableProp prop) {
            this.validate();
            this.autoAttachingSet.add(prop);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setAutoAttaching(Class<?> entityType, String prop) {
            ImmutableType immutableType = ImmutableType.get(entityType);
            ImmutableProp immutableProp = immutableType.getProp(prop);
            return this.setAutoAttaching(immutableProp);
        }

        @Override
        public <T extends Table<?>> AbstractEntitySaveCommand.Cfg setAutoAttaching(Class<T> tableType, Function<T, Table<?>> block) {
            return this.setAutoAttaching(ImmutableProps.join(tableType, block));
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDeleteAction(ImmutableProp prop, DeleteAction deleteAction) {
            this.validate();
            if (!prop.isReference() || !(prop.getStorage() instanceof Column)) {
                throw new IllegalArgumentException("'" + prop + "' must be an reference property bases on foreign key");
            }
            if (deleteAction == DeleteAction.SET_NULL && !prop.isNullable()) {
                throw new IllegalArgumentException("'" + prop + "' is not nullable so that it does not support 'on delete set null'");
            }
            this.deleteActionMap.put(prop, deleteAction);
            return this;
        }

        @Override
        public AbstractEntitySaveCommand.Cfg setDeleteAction(Class<?> entityType, String prop, DeleteAction deleteAction) {
            ImmutableType immutableType = ImmutableType.get(entityType);
            ImmutableProp immutableProp = immutableType.getProp(prop);
            return this.setDeleteAction(immutableProp, deleteAction);
        }

        @Override
        public <T extends Table<?>> AbstractEntitySaveCommand.Cfg setDeleteAction(Class<T> tableType, Function<T, Table<?>> block, DeleteAction deleteAction) {
            return this.setDeleteAction(ImmutableProps.join(tableType, block), deleteAction);
        }

        public Data freeze() {
            if (!this.frozen) {
                this.keyPropMultiMap = Collections.unmodifiableMap(this.keyPropMultiMap);
                this.autoAttachingSet = Collections.unmodifiableSet(this.autoAttachingSet);
                this.deleteActionMap = Collections.unmodifiableMap(this.deleteActionMap);
                this.frozen = true;
            }
            return this;
        }

        private void validate() {
            if (this.frozen) {
                throw new IllegalStateException("The current configuration is frozen");
            }
        }
    }

    private static class KeyPropCfgImpl<T extends Table<?>>
    implements AbstractEntitySaveCommand.KeyPropCfg<T> {
        private Class<T> tableType;
        private List<ImmutableProp> props = new ArrayList<ImmutableProp>();

        KeyPropCfgImpl(Class<T> tableType) {
            this.tableType = tableType;
        }

        public List<ImmutableProp> getProps() {
            return this.props;
        }

        @Override
        public AbstractEntitySaveCommand.KeyPropCfg<T> add(Function<T, PropExpression<?>> block) {
            ImmutableProp prop = ImmutableProps.get(this.tableType, block);
            this.props.add(prop);
            return this;
        }
    }
}

